/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.message;

import java.util.UUID;
import org.signal.libsignal.internal.CalledFromNative;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.message.CiphertextMessage;

public class SenderKeyMessage
extends NativeHandleGuard.SimpleOwner
implements CiphertextMessage,
NativeHandleGuard.Owner {
    @Override
    protected void release(long nativeHandle) {
        Native.SenderKeyMessage_Destroy(nativeHandle);
    }

    @CalledFromNative
    public SenderKeyMessage(long nativeHandle) {
        super(nativeHandle);
    }

    public SenderKeyMessage(byte[] serialized) throws InvalidMessageException, InvalidVersionException, LegacyMessageException {
        super(FilterExceptions.filterExceptions(InvalidMessageException.class, InvalidVersionException.class, LegacyMessageException.class, () -> Native.SenderKeyMessage_Deserialize(serialized)));
    }

    public UUID getDistributionId() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderKeyMessage_GetDistributionId));
    }

    public int getChainId() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderKeyMessage_GetChainId));
    }

    public int getIteration() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderKeyMessage_GetIteration));
    }

    public byte[] getCipherText() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderKeyMessage_GetCipherText));
    }

    public void verifySignature(ECPublicKey signatureKey) throws InvalidMessageException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);
             NativeHandleGuard keyGuard = new NativeHandleGuard(signatureKey);){
            if (!FilterExceptions.filterExceptions(InvalidMessageException.class, () -> Native.SenderKeyMessage_VerifySignature(guard.nativeHandle(), keyGuard.nativeHandle())).booleanValue()) {
                throw new InvalidMessageException("Invalid signature!");
            }
        }
    }

    @Override
    public byte[] serialize() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderKeyMessage_GetSerialized));
    }

    @Override
    public int getType() {
        return 7;
    }
}

