/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.internal.CalledFromNative;
import org.signal.libsignal.net.MultiRecipientSendFailure;
import org.signal.libsignal.protocol.ServiceId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/signal/libsignal/net/MismatchedDeviceException;", "Ljava/io/IOException;", "Lorg/signal/libsignal/net/MultiRecipientSendFailure;", "message", "", "entries", "", "Lorg/signal/libsignal/net/MismatchedDeviceException$Entry;", "<init>", "(Ljava/lang/String;[Lorg/signal/libsignal/net/MismatchedDeviceException$Entry;)V", "getEntries", "()[Lorg/signal/libsignal/net/MismatchedDeviceException$Entry;", "[Lorg/signal/libsignal/net/MismatchedDeviceException$Entry;", "Entry", "libsignal-client"})
public final class MismatchedDeviceException
extends IOException
implements MultiRecipientSendFailure {
    @NotNull
    private final Entry[] entries;

    @NotNull
    public final Entry[] getEntries() {
        return this.entries;
    }

    public MismatchedDeviceException(@NotNull String message, @NotNull Entry[] entries) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        super(message);
        this.entries = entries;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tB)\b\u0013\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\fJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/signal/libsignal/net/MismatchedDeviceException$Entry;", "", "account", "Lorg/signal/libsignal/protocol/ServiceId;", "missingDevices", "", "extraDevices", "staleDevices", "<init>", "(Lorg/signal/libsignal/protocol/ServiceId;[I[I[I)V", "rawAccount", "", "([B[I[I[I)V", "getAccount", "()Lorg/signal/libsignal/protocol/ServiceId;", "getMissingDevices", "()[I", "getExtraDevices", "getStaleDevices", "equals", "", "other", "hashCode", "", "component1", "component2", "component3", "component4", "copy", "toString", "", "libsignal-client"})
    public static final class Entry {
        @NotNull
        private final ServiceId account;
        @NotNull
        private final int[] missingDevices;
        @NotNull
        private final int[] extraDevices;
        @NotNull
        private final int[] staleDevices;

        public Entry(@NotNull ServiceId account, @NotNull int[] missingDevices, @NotNull int[] extraDevices, @NotNull int[] staleDevices) {
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)missingDevices, (String)"missingDevices");
            Intrinsics.checkNotNullParameter((Object)extraDevices, (String)"extraDevices");
            Intrinsics.checkNotNullParameter((Object)staleDevices, (String)"staleDevices");
            this.account = account;
            this.missingDevices = missingDevices;
            this.extraDevices = extraDevices;
            this.staleDevices = staleDevices;
        }

        public /* synthetic */ Entry(ServiceId serviceId, int[] nArray, int[] nArray2, int[] nArray3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                nArray = new int[]{};
            }
            if ((n & 4) != 0) {
                nArray2 = new int[]{};
            }
            if ((n & 8) != 0) {
                nArray3 = new int[]{};
            }
            this(serviceId, nArray, nArray2, nArray3);
        }

        @NotNull
        public final ServiceId getAccount() {
            return this.account;
        }

        @NotNull
        public final int[] getMissingDevices() {
            return this.missingDevices;
        }

        @NotNull
        public final int[] getExtraDevices() {
            return this.extraDevices;
        }

        @NotNull
        public final int[] getStaleDevices() {
            return this.staleDevices;
        }

        @CalledFromNative
        private Entry(byte[] rawAccount, int[] missingDevices, int[] extraDevices, int[] staleDevices) {
            ServiceId serviceId = ServiceId.parseFromFixedWidthBinary(rawAccount);
            Intrinsics.checkNotNullExpressionValue((Object)serviceId, (String)"parseFromFixedWidthBinary(...)");
            this(serviceId, missingDevices, extraDevices, staleDevices);
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Entry)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.account, (Object)((Entry)other).account) && Arrays.equals(this.missingDevices, ((Entry)other).missingDevices) && Arrays.equals(this.extraDevices, ((Entry)other).extraDevices) && Arrays.equals(this.staleDevices, ((Entry)other).staleDevices);
        }

        public int hashCode() {
            int result = this.account.hashCode();
            result = 31 * result + Arrays.hashCode(this.missingDevices);
            result = 31 * result + Arrays.hashCode(this.extraDevices);
            result = 31 * result + Arrays.hashCode(this.staleDevices);
            return result;
        }

        @NotNull
        public final ServiceId component1() {
            return this.account;
        }

        @NotNull
        public final int[] component2() {
            return this.missingDevices;
        }

        @NotNull
        public final int[] component3() {
            return this.extraDevices;
        }

        @NotNull
        public final int[] component4() {
            return this.staleDevices;
        }

        @NotNull
        public final Entry copy(@NotNull ServiceId account, @NotNull int[] missingDevices, @NotNull int[] extraDevices, @NotNull int[] staleDevices) {
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)missingDevices, (String)"missingDevices");
            Intrinsics.checkNotNullParameter((Object)extraDevices, (String)"extraDevices");
            Intrinsics.checkNotNullParameter((Object)staleDevices, (String)"staleDevices");
            return new Entry(account, missingDevices, extraDevices, staleDevices);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, ServiceId serviceId, int[] nArray, int[] nArray2, int[] nArray3, int n, Object object) {
            if ((n & 1) != 0) {
                serviceId = entry.account;
            }
            if ((n & 2) != 0) {
                nArray = entry.missingDevices;
            }
            if ((n & 4) != 0) {
                nArray2 = entry.extraDevices;
            }
            if ((n & 8) != 0) {
                nArray3 = entry.staleDevices;
            }
            return entry.copy(serviceId, nArray, nArray2, nArray3);
        }

        @NotNull
        public String toString() {
            return "Entry(account=" + this.account + ", missingDevices=" + Arrays.toString(this.missingDevices) + ", extraDevices=" + Arrays.toString(this.extraDevices) + ", staleDevices=" + Arrays.toString(this.staleDevices) + ")";
        }
    }
}

