/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.calllinks;

import java.security.SecureRandom;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.GenericServerPublicParams;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.calllinks.CreateCallLinkCredential;
import org.signal.libsignal.zkgroup.calllinks.CreateCallLinkCredentialRequest;
import org.signal.libsignal.zkgroup.calllinks.CreateCallLinkCredentialResponse;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class CreateCallLinkCredentialRequestContext
extends ByteArray {
    public CreateCallLinkCredentialRequestContext(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.CreateCallLinkCredentialRequestContext_CheckValidContents(contents));
    }

    public static CreateCallLinkCredentialRequestContext forRoom(byte[] roomId) {
        return CreateCallLinkCredentialRequestContext.forRoom(roomId, new SecureRandom());
    }

    public static CreateCallLinkCredentialRequestContext forRoom(byte[] roomId, SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.CreateCallLinkCredentialRequestContext_NewDeterministic(roomId, random);
        try {
            return new CreateCallLinkCredentialRequestContext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public CreateCallLinkCredentialRequest getRequest() {
        byte[] newContents = Native.CreateCallLinkCredentialRequestContext_GetRequest(this.contents);
        try {
            return new CreateCallLinkCredentialRequest(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public CreateCallLinkCredential receiveResponse(CreateCallLinkCredentialResponse response, ServiceId.Aci userId, GenericServerPublicParams params) throws VerificationFailedException {
        byte[] newContents = FilterExceptions.filterExceptions(VerificationFailedException.class, () -> Native.CreateCallLinkCredentialRequestContext_ReceiveResponse(this.getInternalContentsForJNI(), response.getInternalContentsForJNI(), userId.toServiceIdFixedWidthBinary(), params.getInternalContentsForJNI()));
        try {
            return new CreateCallLinkCredential(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

