/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.internal.NativeTesting;
import org.signal.libsignal.internal.TokioAsyncContext;
import org.signal.libsignal.net.ChatConnection;
import org.signal.libsignal.protocol.util.Pair;

class FakeChatRemote
extends NativeHandleGuard.SimpleOwner {
    private TokioAsyncContext tokioContext;

    FakeChatRemote(TokioAsyncContext tokioContext, long nativeHandle) {
        super(nativeHandle);
        this.tokioContext = tokioContext;
    }

    public CompletableFuture<Pair<ChatConnection.InternalRequest, Long>> getNextIncomingRequest() {
        return this.tokioContext.guardedMap(asyncContextHandle -> this.guardedMap(fakeRemote -> NativeTesting.TESTING_FakeChatRemoteEnd_ReceiveIncomingRequest(asyncContextHandle, fakeRemote))).thenApply(sentRequest -> {
            try {
                ChatConnection.InternalRequest httpRequest = new ChatConnection.InternalRequest(NativeTesting.TESTING_FakeChatSentRequest_TakeHttpRequest(sentRequest));
                long requestId = NativeTesting.TESTING_FakeChatSentRequest_RequestId(sentRequest);
                Pair<ChatConnection.InternalRequest, Long> pair = new Pair<ChatConnection.InternalRequest, Long>(httpRequest, requestId);
                return pair;
            }
            finally {
                NativeTesting.FakeChatSentRequest_Destroy(sentRequest);
            }
        });
    }

    public void sendResponse(long requestId, int status, String message, String[] headers, byte[] body) {
        NativeHandleGuard.SimpleOwner fakeResponse = new NativeHandleGuard.SimpleOwner(NativeTesting.TESTING_FakeChatResponse_Create(requestId, status, message, headers, body)){

            @Override
            protected void release(long nativeHandle) {
                NativeTesting.FakeChatResponse_Destroy(nativeHandle);
            }
        };
        this.guardedRun(arg_0 -> FakeChatRemote.lambda$sendResponse$4(fakeResponse, arg_0));
    }

    @Override
    protected void release(long nativeHandle) {
        NativeTesting.FakeChatRemoteEnd_Destroy(nativeHandle);
    }

    private static /* synthetic */ void lambda$sendResponse$4(1 fakeResponse, long fakeRemote) {
        fakeResponse.guardedRun(response -> NativeTesting.TESTING_FakeChatRemoteEnd_SendServerResponse(fakeRemote, response));
    }
}

