/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.sgxsession;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.sgxsession.SgxCommunicationFailureException;

public class SgxClient
extends NativeHandleGuard.SimpleOwner {
    protected SgxClient(long nativeHandle) {
        super(nativeHandle);
    }

    @Override
    protected void release(long nativeHandle) {
        Native.SgxClientState_Destroy(nativeHandle);
    }

    public byte[] initialRequest() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SgxClientState_InitialRequest));
    }

    public void completeHandshake(byte[] handshakeResponse) throws SgxCommunicationFailureException {
        FilterExceptions.filterExceptions(SgxCommunicationFailureException.class, () -> this.guardedRunChecked(nativeHandle -> Native.SgxClientState_CompleteHandshake(nativeHandle, handshakeResponse)));
    }

    public byte[] establishedSend(byte[] plaintextToSend) throws SgxCommunicationFailureException {
        return FilterExceptions.filterExceptions(SgxCommunicationFailureException.class, () -> this.guardedMapChecked(nativeHandle -> Native.SgxClientState_EstablishedSend(nativeHandle, plaintextToSend)));
    }

    public byte[] establishedRecv(byte[] receivedCiphertext) throws SgxCommunicationFailureException {
        return FilterExceptions.filterExceptions(SgxCommunicationFailureException.class, () -> this.guardedMapChecked(nativeHandle -> Native.SgxClientState_EstablishedRecv(nativeHandle, receivedCiphertext)));
    }
}

