/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.internal.AsyncKt;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.messagebackup.BackupForwardSecrecyToken;
import org.signal.libsignal.messagebackup.BackupKey;
import org.signal.libsignal.net.BackupRestoreResponse;
import org.signal.libsignal.net.BackupStoreResponse;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.SvrBRestoreResponse;
import org.signal.libsignal.net.SvrBStoreResponse;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\nJ\"\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/signal/libsignal/net/SvrB;", "", "network", "Lorg/signal/libsignal/net/Network;", "username", "", "password", "<init>", "(Lorg/signal/libsignal/net/Network;Ljava/lang/String;Ljava/lang/String;)V", "createNewBackupChain", "", "backupKey", "Lorg/signal/libsignal/messagebackup/BackupKey;", "store", "Lorg/signal/libsignal/internal/CompletableFuture;", "Lkotlin/Result;", "Lorg/signal/libsignal/net/SvrBStoreResponse;", "previousSecretData", "restore", "Lorg/signal/libsignal/net/SvrBRestoreResponse;", "metadata", "libsignal-client"})
public final class SvrB {
    @NotNull
    private final Network network;
    @NotNull
    private final String username;
    @NotNull
    private final String password;

    public SvrB(@NotNull Network network, @NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.network = network;
        this.username = username;
        this.password = password;
    }

    @NotNull
    public final byte[] createNewBackupChain(@NotNull BackupKey backupKey) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        byte[] byArray = Native.SecureValueRecoveryForBackups_CreateNewBackupChain(this.network.getConnectionManager().environment().value, backupKey.getInternalContentsForJNI());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"SecureValueRecoveryForBa\u2026CreateNewBackupChain(...)");
        return byArray;
    }

    @NotNull
    public final CompletableFuture<Result<SvrBStoreResponse>> store(@NotNull BackupKey backupKey, @NotNull byte[] previousSecretData) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)previousSecretData, (String)"previousSecretData");
        CompletableFuture nativeFuture = this.network.getAsyncContext().guardedMap(arg_0 -> SvrB.store$lambda$1(this, backupKey, previousSecretData, arg_0));
        CompletableFuture<SvrBStoreResponse> completableFuture = nativeFuture.thenApply(arg_0 -> SvrB.store$lambda$4(SvrB::store$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"thenApply(...)");
        return AsyncKt.toResultFuture(completableFuture);
    }

    @NotNull
    public final CompletableFuture<Result<SvrBRestoreResponse>> restore(@NotNull BackupKey backupKey, @NotNull byte[] metadata) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        CompletableFuture nativeFuture = this.network.getAsyncContext().guardedMap(arg_0 -> SvrB.restore$lambda$6(this, backupKey, metadata, arg_0));
        CompletableFuture<SvrBRestoreResponse> completableFuture = nativeFuture.thenApply(arg_0 -> SvrB.restore$lambda$9(SvrB::restore$lambda$8, arg_0));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"thenApply(...)");
        return AsyncKt.toResultFuture(completableFuture);
    }

    private static final CompletableFuture store$lambda$1$lambda$0(long $asyncContextHandle, BackupKey $backupKey, byte[] $previousSecretData, SvrB this$0, long connectionManagerHandle) {
        return Native.SecureValueRecoveryForBackups_StoreBackup($asyncContextHandle, $backupKey.getInternalContentsForJNI(), $previousSecretData, connectionManagerHandle, this$0.username, this$0.password);
    }

    private static final CompletableFuture store$lambda$1(SvrB this$0, BackupKey $backupKey, byte[] $previousSecretData, long asyncContextHandle) {
        return this$0.network.getConnectionManager().guardedMap(arg_0 -> SvrB.store$lambda$1$lambda$0(asyncContextHandle, $backupKey, $previousSecretData, this$0, arg_0));
    }

    private static final SvrBStoreResponse store$lambda$3$lambda$2(BackupStoreResponse $response, long l) {
        BackupForwardSecrecyToken backupForwardSecrecyToken = new BackupForwardSecrecyToken($response.guardedMapChecked(Native::BackupStoreResponse_GetForwardSecrecyToken));
        byte[] byArray = $response.guardedMapChecked(Native::BackupStoreResponse_GetNextBackupSecretData);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"guardedMapChecked(...)");
        byte[] byArray2 = $response.guardedMapChecked(Native::BackupStoreResponse_GetOpaqueMetadata);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"guardedMapChecked(...)");
        return new SvrBStoreResponse(backupForwardSecrecyToken, byArray, byArray2);
    }

    private static final SvrBStoreResponse store$lambda$3(Long backupResponseHandle) {
        Intrinsics.checkNotNull((Object)backupResponseHandle);
        BackupStoreResponse response = new BackupStoreResponse(backupResponseHandle);
        return response.guardedMap(arg_0 -> SvrB.store$lambda$3$lambda$2(response, arg_0));
    }

    private static final SvrBStoreResponse store$lambda$4(Function1 $tmp0, Object p0) {
        return (SvrBStoreResponse)$tmp0.invoke(p0);
    }

    private static final CompletableFuture restore$lambda$6$lambda$5(long $asyncContextHandle, BackupKey $backupKey, byte[] $metadata, SvrB this$0, long connectionManagerHandle) {
        return Native.SecureValueRecoveryForBackups_RestoreBackupFromServer($asyncContextHandle, $backupKey.getInternalContentsForJNI(), $metadata, connectionManagerHandle, this$0.username, this$0.password);
    }

    private static final CompletableFuture restore$lambda$6(SvrB this$0, BackupKey $backupKey, byte[] $metadata, long asyncContextHandle) {
        return this$0.network.getConnectionManager().guardedMap(arg_0 -> SvrB.restore$lambda$6$lambda$5(asyncContextHandle, $backupKey, $metadata, this$0, arg_0));
    }

    private static final SvrBRestoreResponse restore$lambda$8$lambda$7(BackupRestoreResponse $response, long l) {
        BackupForwardSecrecyToken backupForwardSecrecyToken = new BackupForwardSecrecyToken($response.guardedMapChecked(Native::BackupRestoreResponse_GetForwardSecrecyToken));
        byte[] byArray = $response.guardedMapChecked(Native::BackupRestoreResponse_GetNextBackupSecretData);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"guardedMapChecked(...)");
        return new SvrBRestoreResponse(backupForwardSecrecyToken, byArray);
    }

    private static final SvrBRestoreResponse restore$lambda$8(Long backupResponseHandle) {
        Intrinsics.checkNotNull((Object)backupResponseHandle);
        BackupRestoreResponse response = new BackupRestoreResponse(backupResponseHandle);
        return response.guardedMap(arg_0 -> SvrB.restore$lambda$8$lambda$7(response, arg_0));
    }

    private static final SvrBRestoreResponse restore$lambda$9(Function1 $tmp0, Object p0) {
        return (SvrBRestoreResponse)$tmp0.invoke(p0);
    }
}

