/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.ManifestRecord;
import org.whispersystems.signalservice.internal.storage.StorageManifest;

public class SignalStorageManifest {
    public static final SignalStorageManifest EMPTY = new SignalStorageManifest(0L, 1, Collections.emptyList());
    private final long version;
    private final int sourceDeviceId;
    private final List<StorageId> storageIds;
    private final Map<Integer, List<StorageId>> storageIdsByType;
    private final byte[] ikm;

    public SignalStorageManifest(long version, int sourceDeviceId, List<StorageId> storageIds) {
        this(version, sourceDeviceId, storageIds, new byte[0]);
    }

    public SignalStorageManifest(long version, int sourceDeviceId, List<StorageId> storageIds, byte[] ikm) {
        this.version = version;
        this.sourceDeviceId = sourceDeviceId;
        this.storageIds = storageIds;
        this.ikm = ikm == null ? new byte[]{} : ikm;
        this.storageIdsByType = new HashMap<Integer, List<StorageId>>();
        for (StorageId id : storageIds) {
            List<StorageId> list = this.storageIdsByType.get(id.getType());
            if (list == null) {
                list = new ArrayList<StorageId>();
            }
            list.add(id);
            this.storageIdsByType.put(id.getType(), list);
        }
    }

    public static SignalStorageManifest deserialize(byte[] serialized) {
        try {
            StorageManifest manifest = StorageManifest.parseFrom(serialized);
            ManifestRecord manifestRecord = ManifestRecord.parseFrom(manifest.getValue());
            ArrayList<StorageId> ids = new ArrayList<StorageId>(manifestRecord.getIdentifiersCount());
            for (ManifestRecord.Identifier id : manifestRecord.getIdentifiersList()) {
                ids.add(StorageId.forType(id.getRaw().toByteArray(), id.getTypeValue()));
            }
            return new SignalStorageManifest(manifest.getVersion(), manifestRecord.getSourceDevice(), ids);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public int getSourceDeviceId() {
        return this.sourceDeviceId;
    }

    public byte[] getIkm() {
        return this.ikm;
    }

    public String getVersionString() {
        return this.version + "." + this.sourceDeviceId;
    }

    public List<StorageId> getStorageIds() {
        return this.storageIds;
    }

    public Optional<StorageId> getAccountStorageId() {
        List<StorageId> list = this.storageIdsByType.get(4);
        if (list != null && list.size() > 0) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    public Map<Integer, List<StorageId>> getStorageIdsByType() {
        return this.storageIdsByType;
    }

    public byte[] serialize() {
        ArrayList<ManifestRecord.Identifier> ids = new ArrayList<ManifestRecord.Identifier>(this.storageIds.size());
        for (StorageId id : this.storageIds) {
            ids.add(ManifestRecord.Identifier.newBuilder().setTypeValue(id.getType()).setRaw(ByteString.copyFrom((byte[])id.getRaw())).build());
        }
        ManifestRecord manifestRecord = ManifestRecord.newBuilder().addAllIdentifiers(ids).setSourceDevice(this.sourceDeviceId).build();
        return StorageManifest.newBuilder().setVersion(this.version).setValue(manifestRecord.toByteString()).build().toByteArray();
    }
}

