/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.push.exceptions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.signal.libsignal.protocol.logging.Log;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;

public class ProofRequiredException
extends NonSuccessfulResponseCodeException {
    private static final String TAG = "ProofRequiredRateLimit";
    private final String token;
    private final Set<Option> options;
    private final long retryAfterSeconds;

    public ProofRequiredException(String token, Set<Option> options, long retryAfterSeconds) {
        super(428);
        this.token = token;
        this.options = options;
        this.retryAfterSeconds = retryAfterSeconds;
    }

    public String getToken() {
        return this.token;
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public long getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    private static Set<Option> parseOptions(List<String> rawOptions) {
        HashSet<Option> options = new HashSet<Option>(rawOptions.size());
        Iterator<String> iterator = rawOptions.iterator();
        block10: while (iterator.hasNext()) {
            String raw;
            switch (raw = iterator.next()) {
                case "captcha": {
                    options.add(Option.CAPTCHA);
                    continue block10;
                }
                case "recaptcha": {
                    options.add(Option.RECAPTCHA);
                    continue block10;
                }
                case "pushChallenge": {
                    options.add(Option.PUSH_CHALLENGE);
                    continue block10;
                }
            }
            Log.w((String)TAG, (String)("Unrecognized challenge option: " + raw));
        }
        return options;
    }

    public static enum Option {
        RECAPTCHA,
        CAPTCHA,
        PUSH_CHALLENGE;

    }
}

