/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.push.exceptions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import org.whispersystems.signalservice.api.Util;
import org.whispersystems.signalservice.api.push.exceptions.MalformedResponseException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;

public class NonNormalizedPhoneNumberException
extends NonSuccessfulResponseCodeException {
    private final String originalNumber;
    private final String normalizedNumber;

    public static NonNormalizedPhoneNumberException forResponse(String responseBody) throws MalformedResponseException {
        JsonResponse response;
        try {
            response = Util.fromJson(responseBody, JsonResponse.class);
        }
        catch (JsonProcessingException ex) {
            throw new MalformedResponseException("wrong json", (IOException)((Object)ex));
        }
        return new NonNormalizedPhoneNumberException(response.originalNumber, response.normalizedNumber);
    }

    public NonNormalizedPhoneNumberException(String originalNumber, String normalizedNumber) {
        super(400);
        this.originalNumber = originalNumber;
        this.normalizedNumber = normalizedNumber;
    }

    public String getOriginalNumber() {
        return this.originalNumber;
    }

    public String getNormalizedNumber() {
        return this.normalizedNumber;
    }

    private static class JsonResponse {
        @JsonProperty
        private String originalNumber;
        @JsonProperty
        private String normalizedNumber;

        private JsonResponse() {
        }
    }
}

