/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.push;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.signal.libsignal.protocol.ServiceId;

public class SignalServiceAddress {
    public static final int DEFAULT_DEVICE_ID = 1;
    private ServiceId serviceId;
    private final Optional<String> e164;

    public SignalServiceAddress(ServiceId serviceId, Optional<String> e164) {
        this.serviceId = serviceId;
        this.e164 = e164;
    }

    public SignalServiceAddress(ServiceId serviceId) {
        this.serviceId = serviceId;
        this.e164 = Optional.empty();
    }

    public SignalServiceAddress(ServiceId serviceId, String e164) {
        this(serviceId, e164 == null ? Optional.empty() : (e164.isEmpty() ? Optional.empty() : Optional.of(e164)));
    }

    public Optional<String> getNumber() {
        return this.e164;
    }

    public ServiceId getServiceId() {
        return this.serviceId;
    }

    public boolean hasValidServiceId() {
        return this.serviceId != null && this.serviceId.toServiceIdString() != null;
    }

    public String getIdentifier() {
        return this.serviceId.toServiceIdString();
    }

    public boolean matches(SignalServiceAddress other) {
        return this.serviceId.equals((Object)other.serviceId);
    }

    public static boolean isValidAddress(String rawUuid) {
        return SignalServiceAddress.isValidAddress(rawUuid, null);
    }

    public static boolean isValidAddress(String rawUuid, String e164) {
        try {
            UUID.fromString(rawUuid);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static Optional<SignalServiceAddress> fromRaw(String rawUuid, String e164) {
        if (SignalServiceAddress.isValidAddress(rawUuid, e164)) {
            try {
                return Optional.of(new SignalServiceAddress(ServiceId.parseFromString((String)rawUuid), e164));
            }
            catch (ServiceId.InvalidServiceIdException ex) {
                throw new IllegalArgumentException();
            }
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalServiceAddress that = (SignalServiceAddress)o;
        return this.serviceId.equals((Object)that.serviceId) && this.e164.equals(that.e164);
    }

    public int hashCode() {
        return Objects.hash(this.serviceId, this.e164);
    }

    @Deprecated
    public Optional<UUID> getUuid() {
        return Optional.of(this.serviceId.getRawUUID());
    }
}

