/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.push;

import com.google.protobuf.ByteString;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;

public final class ServiceIds {
    private static final Logger LOG = Logger.getLogger(ServiceIds.class.getName());
    private final ServiceId.Aci aci;
    private final ServiceId.Pni pni;
    private ByteString aciByteString;
    private ByteString pniByteString;

    public ServiceIds(ServiceId.Aci aci, ServiceId.Pni pni) {
        this.aci = aci;
        this.pni = pni;
    }

    public ServiceId.Aci getAci() {
        return this.aci;
    }

    public ServiceId.Pni getPni() {
        return this.pni;
    }

    public ServiceId.Pni requirePni() {
        return Objects.requireNonNull(this.pni);
    }

    public boolean matches(ServiceId serviceId) {
        return serviceId.equals((Object)this.aci) || this.pni != null && serviceId.equals((Object)this.pni);
    }

    public boolean matches(ByteString uuid) {
        if (this.aciByteString == null) {
            this.aciByteString = ByteString.copyFrom((byte[])this.aci.toServiceIdBinary());
        }
        if (this.pniByteString == null && this.pni != null) {
            this.pniByteString = ByteString.copyFrom((byte[])this.pni.toServiceIdBinary());
        }
        return uuid.equals((Object)this.aciByteString) || uuid.equals((Object)this.pniByteString);
    }

    public static class ACI {
        public static ServiceId.Aci parseOrUnknown(ByteString aciBytes) {
            try {
                return ServiceId.Aci.parseFromBinary((byte[])aciBytes.toByteArray());
            }
            catch (ServiceId.InvalidServiceIdException ex) {
                LOG.log(Level.SEVERE, null, ex);
                return null;
            }
        }

        public static ServiceId.Aci parseOrNull(ByteString aciBytes) {
            return ACI.parseOrUnknown(aciBytes);
        }
    }
}

