/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import java.util.List;
import java.util.Optional;
import org.whispersystems.signalservice.api.messages.SignalServicePreview;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class SignalServiceTextAttachment {
    private final Optional<String> text;
    private final Optional<Style> style;
    private final Optional<Integer> textForegroundColor;
    private final Optional<Integer> textBackgroundColor;
    private final Optional<SignalServicePreview> preview;
    private final Optional<Gradient> backgroundGradient;
    private final Optional<Integer> backgroundColor;

    private SignalServiceTextAttachment(Optional<String> text, Optional<Style> style, Optional<Integer> textForegroundColor, Optional<Integer> textBackgroundColor, Optional<SignalServicePreview> preview, Optional<Gradient> backgroundGradient, Optional<Integer> backgroundColor) {
        this.text = text;
        this.style = style;
        this.textForegroundColor = textForegroundColor;
        this.textBackgroundColor = textBackgroundColor;
        this.preview = preview;
        this.backgroundGradient = backgroundGradient;
        this.backgroundColor = backgroundColor;
    }

    public static SignalServiceTextAttachment forGradientBackground(Optional<String> text, Optional<Style> style, Optional<Integer> textForegroundColor, Optional<Integer> textBackgroundColor, Optional<SignalServicePreview> preview, Gradient backgroundGradient) {
        return new SignalServiceTextAttachment(text, style, textForegroundColor, textBackgroundColor, preview, Optional.of(backgroundGradient), Optional.empty());
    }

    public static SignalServiceTextAttachment forSolidBackground(Optional<String> text, Optional<Style> style, Optional<Integer> textForegroundColor, Optional<Integer> textBackgroundColor, Optional<SignalServicePreview> preview, int backgroundColor) {
        return new SignalServiceTextAttachment(text, style, textForegroundColor, textBackgroundColor, preview, Optional.empty(), Optional.of(backgroundColor));
    }

    public Optional<String> getText() {
        return this.text;
    }

    public Optional<Style> getStyle() {
        return this.style;
    }

    public Optional<Integer> getTextForegroundColor() {
        return this.textForegroundColor;
    }

    public Optional<Integer> getTextBackgroundColor() {
        return this.textBackgroundColor;
    }

    public Optional<SignalServicePreview> getPreview() {
        return this.preview;
    }

    public Optional<Gradient> getBackgroundGradient() {
        return this.backgroundGradient;
    }

    public Optional<Integer> getBackgroundColor() {
        return this.backgroundColor;
    }

    public SignalServiceProtos.TextAttachment.Builder toTextAttachmentBuilder() {
        SignalServiceProtos.TextAttachment.Builder builder = SignalServiceProtos.TextAttachment.newBuilder();
        if (this.getStyle().isPresent()) {
            switch (this.getStyle().get().ordinal()) {
                case 0: {
                    builder.setTextStyle(SignalServiceProtos.TextAttachment.Style.DEFAULT);
                    break;
                }
                case 1: {
                    builder.setTextStyle(SignalServiceProtos.TextAttachment.Style.REGULAR);
                    break;
                }
                case 2: {
                    builder.setTextStyle(SignalServiceProtos.TextAttachment.Style.BOLD);
                    break;
                }
                case 3: {
                    builder.setTextStyle(SignalServiceProtos.TextAttachment.Style.SERIF);
                    break;
                }
                case 4: {
                    builder.setTextStyle(SignalServiceProtos.TextAttachment.Style.SCRIPT);
                    break;
                }
                case 5: {
                    builder.setTextStyle(SignalServiceProtos.TextAttachment.Style.CONDENSED);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + String.valueOf((Object)this.getStyle().get())));
                }
            }
        }
        SignalServiceProtos.TextAttachment.Gradient.Builder gradientBuilder = SignalServiceProtos.TextAttachment.Gradient.newBuilder();
        if (this.getBackgroundGradient().isPresent()) {
            Gradient gradient = this.getBackgroundGradient().get();
            if (gradient.getAngle().isPresent()) {
                gradientBuilder.setAngle(gradient.getAngle().get());
            }
            if (!gradient.getColors().isEmpty()) {
                gradientBuilder.setStartColor(gradient.getColors().get(0));
                gradientBuilder.setEndColor(gradient.getColors().get(gradient.getColors().size() - 1));
            }
            gradientBuilder.addAllColors(gradient.getColors());
            gradientBuilder.addAllPositions(gradient.getPositions());
            builder.setGradient(gradientBuilder.build());
        }
        if (this.getText().isPresent()) {
            builder.setText(this.getText().get());
        }
        if (this.getTextForegroundColor().isPresent()) {
            builder.setTextForegroundColor(this.getTextForegroundColor().get());
        }
        if (this.getTextBackgroundColor().isPresent()) {
            builder.setTextBackgroundColor(this.getTextBackgroundColor().get());
        }
        if (this.getBackgroundColor().isPresent()) {
            builder.setColor(this.getBackgroundColor().get());
        }
        return builder;
    }

    public static enum Style {
        DEFAULT,
        REGULAR,
        BOLD,
        SERIF,
        SCRIPT,
        CONDENSED;

    }

    public static class Gradient {
        private final Optional<Integer> angle;
        private final List<Integer> colors;
        private final List<Float> positions;

        public Gradient(Optional<Integer> angle, List<Integer> colors, List<Float> positions) {
            this.angle = angle;
            this.colors = colors;
            this.positions = positions;
        }

        public Optional<Integer> getAngle() {
            return this.angle;
        }

        public List<Integer> getColors() {
            return this.colors;
        }

        public List<Float> getPositions() {
            return this.positions;
        }
    }
}

