/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import java.util.List;
import java.util.Optional;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupV2;
import org.whispersystems.signalservice.api.messages.SignalServiceTextAttachment;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class SignalServiceStoryMessage {
    private final Optional<byte[]> profileKey;
    private final Optional<SignalServiceGroupV2> groupContext;
    private final Optional<SignalServiceAttachment> fileAttachment;
    private final Optional<SignalServiceTextAttachment> textAttachment;
    private final Optional<Boolean> allowsReplies;
    private final Optional<List<SignalServiceProtos.BodyRange>> bodyRanges;

    private SignalServiceStoryMessage(byte[] profileKey, SignalServiceGroupV2 groupContext, SignalServiceAttachment fileAttachment, SignalServiceTextAttachment textAttachment, boolean allowsReplies, List<SignalServiceProtos.BodyRange> bodyRanges) {
        this.profileKey = Optional.ofNullable(profileKey);
        this.groupContext = Optional.ofNullable(groupContext);
        this.fileAttachment = Optional.ofNullable(fileAttachment);
        this.textAttachment = Optional.ofNullable(textAttachment);
        this.allowsReplies = Optional.of(allowsReplies);
        this.bodyRanges = Optional.ofNullable(bodyRanges);
    }

    public static SignalServiceStoryMessage forFileAttachment(byte[] profileKey, SignalServiceGroupV2 groupContext, SignalServiceAttachment fileAttachment, boolean allowsReplies, List<SignalServiceProtos.BodyRange> bodyRanges) {
        return new SignalServiceStoryMessage(profileKey, groupContext, fileAttachment, null, allowsReplies, bodyRanges);
    }

    public static SignalServiceStoryMessage forTextAttachment(byte[] profileKey, SignalServiceGroupV2 groupContext, SignalServiceTextAttachment textAttachment, boolean allowsReplies, List<SignalServiceProtos.BodyRange> bodyRanges) {
        return new SignalServiceStoryMessage(profileKey, groupContext, null, textAttachment, allowsReplies, bodyRanges);
    }

    public Optional<byte[]> getProfileKey() {
        return this.profileKey;
    }

    public Optional<SignalServiceGroupV2> getGroupContext() {
        return this.groupContext;
    }

    public Optional<SignalServiceAttachment> getFileAttachment() {
        return this.fileAttachment;
    }

    public Optional<SignalServiceTextAttachment> getTextAttachment() {
        return this.textAttachment;
    }

    public Optional<Boolean> getAllowsReplies() {
        return this.allowsReplies;
    }

    public Optional<List<SignalServiceProtos.BodyRange>> getBodyRanges() {
        return this.bodyRanges;
    }
}

