/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import org.signal.libsignal.protocol.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.SignalServiceProtos;
import org.whispersystems.signalservice.internal.serialize.protos.SignalServiceEnvelopeProto;

public class SignalServiceEnvelope {
    private static final String TAG = SignalServiceEnvelope.class.getSimpleName();
    private final SignalServiceProtos.Envelope envelope;
    private final long serverDeliveredTimestamp;

    public SignalServiceEnvelope(String message, long serverDeliveredTimestamp) throws IOException {
        this(Base64.getDecoder().decode(message), serverDeliveredTimestamp);
    }

    public SignalServiceEnvelope(byte[] input, long serverDeliveredTimestamp) throws IOException {
        this.envelope = SignalServiceProtos.Envelope.parseFrom(input);
        this.serverDeliveredTimestamp = serverDeliveredTimestamp;
    }

    public SignalServiceEnvelope(int type, Optional<SignalServiceAddress> sender, int senderDevice, long timestamp, byte[] content, long serverReceivedTimestamp, long serverDeliveredTimestamp, String uuid, String destinationUuid, boolean urgent, boolean story) {
        SignalServiceProtos.Envelope.Builder builder = SignalServiceProtos.Envelope.newBuilder().setType(SignalServiceProtos.Envelope.Type.valueOf(type)).setSourceDevice(senderDevice).setTimestamp(timestamp).setServerTimestamp(serverReceivedTimestamp).setDestinationServiceId(destinationUuid).setUrgent(urgent).setStory(story);
        if (sender.isPresent()) {
            builder.setSourceServiceId(sender.get().getServiceId().toString());
        }
        if (uuid != null) {
            builder.setServerGuid(uuid);
        }
        if (content != null) {
            builder.setContent(ByteString.copyFrom((byte[])content));
        }
        this.envelope = builder.build();
        this.serverDeliveredTimestamp = serverDeliveredTimestamp;
    }

    public SignalServiceEnvelope(int type, long timestamp, byte[] content, long serverReceivedTimestamp, long serverDeliveredTimestamp, String uuid, String destinationUuid, boolean urgent, boolean story) {
        SignalServiceProtos.Envelope.Builder builder = SignalServiceProtos.Envelope.newBuilder().setType(SignalServiceProtos.Envelope.Type.valueOf(type)).setTimestamp(timestamp).setServerTimestamp(serverReceivedTimestamp).setDestinationServiceId(destinationUuid).setUrgent(urgent).setStory(story);
        if (uuid != null) {
            builder.setServerGuid(uuid);
        }
        if (content != null) {
            builder.setContent(ByteString.copyFrom((byte[])content));
        }
        this.envelope = builder.build();
        this.serverDeliveredTimestamp = serverDeliveredTimestamp;
    }

    public SignalServiceProtos.Envelope getEnvelope() {
        return this.envelope;
    }

    public String getServerGuid() {
        return this.envelope.getServerGuid();
    }

    public boolean hasServerGuid() {
        return this.envelope.hasServerGuid();
    }

    public boolean hasSourceUuid() {
        return this.envelope.hasSourceServiceId();
    }

    public Optional<String> getSourceUuid() {
        return Optional.ofNullable(this.envelope.getSourceServiceId());
    }

    public String getSourceIdentifier() {
        return this.getSourceUuid().get().toString();
    }

    public boolean hasSourceDevice() {
        return this.envelope.hasSourceDevice();
    }

    public int getSourceDevice() {
        return this.envelope.getSourceDevice();
    }

    public SignalServiceAddress getSourceAddress() {
        try {
            return new SignalServiceAddress(ServiceId.parseFromString((String)this.envelope.getSourceServiceId()));
        }
        catch (ServiceId.InvalidServiceIdException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public int getType() {
        return this.envelope.getType().getNumber();
    }

    public long getTimestamp() {
        return this.envelope.getTimestamp();
    }

    public long getServerReceivedTimestamp() {
        return this.envelope.getServerTimestamp();
    }

    public long getServerDeliveredTimestamp() {
        return this.serverDeliveredTimestamp;
    }

    public boolean hasContent() {
        return this.envelope.hasContent();
    }

    public byte[] getContent() {
        return this.envelope.getContent().toByteArray();
    }

    public boolean isSignalMessage() {
        return this.envelope.getType().getNumber() == 1;
    }

    public boolean isPreKeySignalMessage() {
        return this.envelope.getType().getNumber() == 3;
    }

    public boolean isReceipt() {
        return this.envelope.getType().getNumber() == 5;
    }

    public boolean isUnidentifiedSender() {
        return this.envelope.getType().getNumber() == 6;
    }

    public boolean isPlaintextContent() {
        return this.envelope.getType().getNumber() == 8;
    }

    public boolean hasDestinationUuid() {
        return this.envelope.hasDestinationServiceId() && UUID.fromString(this.envelope.getDestinationServiceId()) != null;
    }

    public String getDestinationUuid() {
        return this.envelope.getDestinationServiceId();
    }

    public boolean isUrgent() {
        return this.envelope.getUrgent();
    }

    public boolean isStory() {
        return this.envelope.getStory();
    }

    private SignalServiceEnvelopeProto.Builder serializeToProto() {
        SignalServiceEnvelopeProto.Builder builder = SignalServiceEnvelopeProto.newBuilder().setType(this.getType()).setDeviceId(this.getSourceDevice()).setTimestamp(this.getTimestamp()).setServerReceivedTimestamp(this.getServerReceivedTimestamp()).setServerDeliveredTimestamp(this.getServerDeliveredTimestamp()).setUrgent(this.isUrgent()).setStory(this.isStory());
        if (this.getSourceUuid().isPresent()) {
            builder.setSourceUuid(this.getSourceUuid().get());
        }
        if (this.hasContent()) {
            builder.setContent(ByteString.copyFrom((byte[])this.getContent()));
        }
        if (this.hasServerGuid()) {
            builder.setServerGuid(this.getServerGuid());
        }
        if (this.hasDestinationUuid()) {
            builder.setDestinationUuid(this.getDestinationUuid());
        }
        return builder;
    }

    public byte[] serialize() {
        return this.serializeToProto().build().toByteArray();
    }

    public static SignalServiceEnvelope deserialize(byte[] serialized) {
        SignalServiceEnvelopeProto proto = null;
        try {
            proto = SignalServiceEnvelopeProto.parseFrom(serialized);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        ServiceId sourceServiceId = null;
        try {
            sourceServiceId = proto.hasSourceUuid() ? ServiceId.parseFromString((String)proto.getSourceUuid()) : null;
        }
        catch (ServiceId.InvalidServiceIdException ex) {
            throw new IllegalArgumentException(ex);
        }
        return new SignalServiceEnvelope(proto.getType(), sourceServiceId != null ? Optional.of(new SignalServiceAddress(sourceServiceId)) : Optional.empty(), proto.getDeviceId(), proto.getTimestamp(), proto.hasContent() ? proto.getContent().toByteArray() : null, proto.getServerReceivedTimestamp(), proto.getServerDeliveredTimestamp(), proto.getServerGuid(), proto.getDestinationUuid(), proto.getUrgent(), proto.getStory());
    }
}

