/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.groupsv2;

import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.signal.storageservice.protos.groups.local.DecryptedApproveMember;
import org.signal.storageservice.protos.groups.local.DecryptedBannedMember;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.protos.groups.local.DecryptedMember;
import org.signal.storageservice.protos.groups.local.DecryptedModifyMemberRole;
import org.signal.storageservice.protos.groups.local.DecryptedPendingMember;
import org.signal.storageservice.protos.groups.local.DecryptedPendingMemberRemoval;
import org.signal.storageservice.protos.groups.local.DecryptedRequestingMember;
import org.signal.storageservice.protos.groups.local.DecryptedString;

public final class GroupChangeReconstruct {
    public static DecryptedGroupChange reconstructGroupChange(DecryptedGroup fromState, DecryptedGroup toState) {
        DecryptedGroupChange.Builder builder = DecryptedGroupChange.newBuilder().setRevision(toState.getRevision());
        if (!fromState.getTitle().equals(toState.getTitle())) {
            builder.setNewTitle(DecryptedString.newBuilder().setValue(toState.getTitle()));
        }
        if (!fromState.getDescription().equals(toState.getDescription())) {
            builder.setNewDescription(DecryptedString.newBuilder().setValue(toState.getDescription()));
        }
        if (!fromState.getIsAnnouncementGroup().equals((Object)toState.getIsAnnouncementGroup())) {
            builder.setNewIsAnnouncementGroup(toState.getIsAnnouncementGroup());
        }
        if (!fromState.getAvatar().equals(toState.getAvatar())) {
            builder.setNewAvatar(DecryptedString.newBuilder().setValue(toState.getAvatar()));
        }
        if (!fromState.getDisappearingMessagesTimer().equals(toState.getDisappearingMessagesTimer())) {
            builder.setNewTimer(toState.getDisappearingMessagesTimer());
        }
        if (!fromState.getAccessControl().getAttributes().equals((Object)toState.getAccessControl().getAttributes())) {
            builder.setNewAttributeAccess(toState.getAccessControl().getAttributes());
        }
        if (!fromState.getAccessControl().getMembers().equals((Object)toState.getAccessControl().getMembers())) {
            builder.setNewMemberAccess(toState.getAccessControl().getMembers());
        }
        Set<ByteString> fromStateMemberAcis = GroupChangeReconstruct.membersToSetOfAcis(fromState.getMembersList());
        Set<ByteString> toStateMemberAcis = GroupChangeReconstruct.membersToSetOfAcis(toState.getMembersList());
        Set<ByteString> pendingMembersListA = GroupChangeReconstruct.pendingMembersToSetOfServiceIds(fromState.getPendingMembersList());
        Set<ByteString> pendingMembersListB = GroupChangeReconstruct.pendingMembersToSetOfServiceIds(toState.getPendingMembersList());
        Set<ByteString> requestingMembersListA = GroupChangeReconstruct.requestingMembersToSetOfAcis(fromState.getRequestingMembersList());
        Set<ByteString> requestingMembersListB = GroupChangeReconstruct.requestingMembersToSetOfAcis(toState.getRequestingMembersList());
        Set<ByteString> bannedMembersListA = GroupChangeReconstruct.bannedMembersToSetOfServiceIds(fromState.getBannedMembersList());
        Set<ByteString> bannedMembersListB = GroupChangeReconstruct.bannedMembersToSetOfServiceIds(toState.getBannedMembersList());
        Set<ByteString> removedPendingMemberServiceIds = GroupChangeReconstruct.subtract(pendingMembersListA, pendingMembersListB);
        Set<ByteString> removedRequestingMemberAcis = GroupChangeReconstruct.subtract(requestingMembersListA, requestingMembersListB);
        Set<ByteString> newPendingMemberServiceIds = GroupChangeReconstruct.subtract(pendingMembersListB, pendingMembersListA);
        Set<ByteString> newRequestingMemberAcis = GroupChangeReconstruct.subtract(requestingMembersListB, requestingMembersListA);
        Set<ByteString> removedMemberAcis = GroupChangeReconstruct.subtract(fromStateMemberAcis, toStateMemberAcis);
        Set<ByteString> newMemberAcis = GroupChangeReconstruct.subtract(toStateMemberAcis, fromStateMemberAcis);
        Set<ByteString> removedBannedMemberServiceIds = GroupChangeReconstruct.subtract(bannedMembersListA, bannedMembersListB);
        Set<ByteString> newBannedMemberServiceIds = GroupChangeReconstruct.subtract(bannedMembersListB, bannedMembersListA);
        Set<ByteString> addedByInvitationAcis = GroupChangeReconstruct.intersect(newMemberAcis, removedPendingMemberServiceIds);
        Set<ByteString> addedByRequestApprovalAcis = GroupChangeReconstruct.intersect(newMemberAcis, removedRequestingMemberAcis);
        Set<DecryptedMember> addedMembersByInvitation = GroupChangeReconstruct.intersectByAci(toState.getMembersList(), addedByInvitationAcis);
        Set<DecryptedMember> addedMembersByRequestApproval = GroupChangeReconstruct.intersectByAci(toState.getMembersList(), addedByRequestApprovalAcis);
        Set<DecryptedMember> addedMembers = GroupChangeReconstruct.intersectByAci(toState.getMembersList(), GroupChangeReconstruct.subtract(newMemberAcis, addedByInvitationAcis, addedByRequestApprovalAcis));
        Set<DecryptedPendingMember> uninvitedMembers = GroupChangeReconstruct.intersectPendingByServiceId(fromState.getPendingMembersList(), GroupChangeReconstruct.subtract(removedPendingMemberServiceIds, addedByInvitationAcis));
        Set<DecryptedRequestingMember> rejectedRequestMembers = GroupChangeReconstruct.intersectRequestingByAci(fromState.getRequestingMembersList(), GroupChangeReconstruct.subtract(removedRequestingMemberAcis, addedByRequestApprovalAcis));
        for (DecryptedMember member : GroupChangeReconstruct.intersectByAci(fromState.getMembersList(), removedMemberAcis)) {
            builder.addDeleteMembers(member.getAciBytes());
        }
        for (DecryptedMember member : addedMembers) {
            builder.addNewMembers(member);
        }
        for (DecryptedMember member : addedMembersByInvitation) {
            builder.addPromotePendingMembers(member);
        }
        for (DecryptedPendingMember uninvitedMember : uninvitedMembers) {
            builder.addDeletePendingMembers(DecryptedPendingMemberRemoval.newBuilder().setServiceIdBytes(uninvitedMember.getServiceIdBytes()).setServiceIdCipherText(uninvitedMember.getServiceIdCipherText()));
        }
        for (DecryptedPendingMember invitedMember : GroupChangeReconstruct.intersectPendingByServiceId(toState.getPendingMembersList(), newPendingMemberServiceIds)) {
            builder.addNewPendingMembers(invitedMember);
        }
        Set<ByteString> consistentMemberAcis = GroupChangeReconstruct.intersect(fromStateMemberAcis, toStateMemberAcis);
        Set<DecryptedMember> changedMembers = GroupChangeReconstruct.intersectByAci(GroupChangeReconstruct.subtract(toState.getMembersList(), fromState.getMembersList()), consistentMemberAcis);
        Map<ByteString, DecryptedMember> membersAciMap = GroupChangeReconstruct.mapByAci(fromState.getMembersList());
        Map<ByteString, DecryptedBannedMember> bannedMembersServiceIdMap = GroupChangeReconstruct.bannedServiceIdMap(toState.getBannedMembersList());
        for (DecryptedMember newState : changedMembers) {
            DecryptedMember oldState = membersAciMap.get(newState.getAciBytes());
            if (oldState.getRole() != newState.getRole()) {
                builder.addModifyMemberRoles(DecryptedModifyMemberRole.newBuilder().setAciBytes(newState.getAciBytes()).setRole(newState.getRole()));
            }
            if (oldState.getProfileKey().equals((Object)newState.getProfileKey())) continue;
            builder.addModifiedProfileKeys(newState);
        }
        if (!fromState.getAccessControl().getAddFromInviteLink().equals((Object)toState.getAccessControl().getAddFromInviteLink())) {
            builder.setNewInviteLinkAccess(toState.getAccessControl().getAddFromInviteLink());
        }
        for (DecryptedRequestingMember requestingMember : GroupChangeReconstruct.intersectRequestingByAci(toState.getRequestingMembersList(), newRequestingMemberAcis)) {
            builder.addNewRequestingMembers(requestingMember);
        }
        for (DecryptedRequestingMember requestingMember : rejectedRequestMembers) {
            builder.addDeleteRequestingMembers(requestingMember.getAciBytes());
        }
        for (DecryptedMember member : addedMembersByRequestApproval) {
            builder.addPromoteRequestingMembers(DecryptedApproveMember.newBuilder().setAciBytes(member.getAciBytes()).setRole(member.getRole()));
        }
        if (!fromState.getInviteLinkPassword().equals((Object)toState.getInviteLinkPassword())) {
            builder.setNewInviteLinkPassword(toState.getInviteLinkPassword());
        }
        for (ByteString serviceIdBinary : removedBannedMemberServiceIds) {
            builder.addDeleteBannedMembers(DecryptedBannedMember.newBuilder().setServiceIdBytes(serviceIdBinary).build());
        }
        for (ByteString serviceIdBinary : newBannedMemberServiceIds) {
            DecryptedBannedMember.Builder newBannedBuilder = DecryptedBannedMember.newBuilder().setServiceIdBytes(serviceIdBinary);
            DecryptedBannedMember bannedMember = bannedMembersServiceIdMap.get(serviceIdBinary);
            if (bannedMember != null) {
                newBannedBuilder.setTimestamp(bannedMember.getTimestamp());
            }
            builder.addNewBannedMembers(newBannedBuilder);
        }
        return builder.build();
    }

    private static Map<ByteString, DecryptedMember> mapByAci(List<DecryptedMember> membersList) {
        LinkedHashMap<ByteString, DecryptedMember> map = new LinkedHashMap<ByteString, DecryptedMember>(membersList.size());
        for (DecryptedMember member : membersList) {
            map.put(member.getAciBytes(), member);
        }
        return map;
    }

    private static Map<ByteString, DecryptedBannedMember> bannedServiceIdMap(List<DecryptedBannedMember> membersList) {
        LinkedHashMap<ByteString, DecryptedBannedMember> map = new LinkedHashMap<ByteString, DecryptedBannedMember>(membersList.size());
        for (DecryptedBannedMember member : membersList) {
            map.put(member.getServiceIdBytes(), member);
        }
        return map;
    }

    private static Set<DecryptedMember> intersectByAci(Collection<DecryptedMember> members, Set<ByteString> acis) {
        LinkedHashSet<DecryptedMember> result = new LinkedHashSet<DecryptedMember>(members.size());
        for (DecryptedMember member : members) {
            if (!acis.contains(member.getAciBytes())) continue;
            result.add(member);
        }
        return result;
    }

    private static Set<DecryptedPendingMember> intersectPendingByServiceId(Collection<DecryptedPendingMember> members, Set<ByteString> serviceIds) {
        LinkedHashSet<DecryptedPendingMember> result = new LinkedHashSet<DecryptedPendingMember>(members.size());
        for (DecryptedPendingMember member : members) {
            if (!serviceIds.contains(member.getServiceIdBytes())) continue;
            result.add(member);
        }
        return result;
    }

    private static Set<DecryptedRequestingMember> intersectRequestingByAci(Collection<DecryptedRequestingMember> members, Set<ByteString> acis) {
        LinkedHashSet<DecryptedRequestingMember> result = new LinkedHashSet<DecryptedRequestingMember>(members.size());
        for (DecryptedRequestingMember member : members) {
            if (!acis.contains(member.getAciBytes())) continue;
            result.add(member);
        }
        return result;
    }

    private static Set<ByteString> pendingMembersToSetOfServiceIds(Collection<DecryptedPendingMember> pendingMembers) {
        LinkedHashSet<ByteString> serviceIds = new LinkedHashSet<ByteString>(pendingMembers.size());
        for (DecryptedPendingMember pendingMember : pendingMembers) {
            serviceIds.add(pendingMember.getServiceIdBytes());
        }
        return serviceIds;
    }

    private static Set<ByteString> requestingMembersToSetOfAcis(Collection<DecryptedRequestingMember> requestingMembers) {
        LinkedHashSet<ByteString> acis = new LinkedHashSet<ByteString>(requestingMembers.size());
        for (DecryptedRequestingMember requestingMember : requestingMembers) {
            acis.add(requestingMember.getAciBytes());
        }
        return acis;
    }

    private static Set<ByteString> membersToSetOfAcis(Collection<DecryptedMember> members) {
        LinkedHashSet<ByteString> acis = new LinkedHashSet<ByteString>(members.size());
        for (DecryptedMember member : members) {
            acis.add(member.getAciBytes());
        }
        return acis;
    }

    private static Set<ByteString> bannedMembersToSetOfServiceIds(Collection<DecryptedBannedMember> bannedMembers) {
        LinkedHashSet<ByteString> serviceIds = new LinkedHashSet<ByteString>(bannedMembers.size());
        for (DecryptedBannedMember bannedMember : bannedMembers) {
            serviceIds.add(bannedMember.getServiceIdBytes());
        }
        return serviceIds;
    }

    private static <T> Set<T> subtract(Collection<T> a, Collection<T> b) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(a);
        result.removeAll(b);
        return result;
    }

    private static <T> Set<T> subtract(Collection<T> a, Collection<T> b, Collection<T> c) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(a);
        result.removeAll(b);
        result.removeAll(c);
        return result;
    }

    private static <T> Set<T> intersect(Collection<T> a, Collection<T> b) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(a);
        result.retainAll(b);
        return result;
    }
}

