/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.groupsv2;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.storageservice.protos.groups.AccessControl;
import org.signal.storageservice.protos.groups.Member;
import org.signal.storageservice.protos.groups.local.DecryptedApproveMember;
import org.signal.storageservice.protos.groups.local.DecryptedBannedMember;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.protos.groups.local.DecryptedMember;
import org.signal.storageservice.protos.groups.local.DecryptedModifyMemberRole;
import org.signal.storageservice.protos.groups.local.DecryptedPendingMember;
import org.signal.storageservice.protos.groups.local.DecryptedPendingMemberRemoval;
import org.signal.storageservice.protos.groups.local.DecryptedRequestingMember;
import org.signal.storageservice.protos.groups.local.EnabledState;
import org.whispersystems.signalservice.api.groupsv2.NotAbleToApplyGroupV2ChangeException;
import org.whispersystems.signalservice.api.push.ServiceIds;

public final class DecryptedGroupUtil {
    private static final String TAG = DecryptedGroupUtil.class.getSimpleName();

    public static ArrayList<ServiceId.Aci> toAciListWithUnknowns(Collection<DecryptedMember> membersList) {
        ArrayList<ServiceId.Aci> serviceIdList = new ArrayList<ServiceId.Aci>(membersList.size());
        for (DecryptedMember member : membersList) {
            serviceIdList.add(ServiceIds.ACI.parseOrUnknown(member.getAciBytes()));
        }
        return serviceIdList;
    }

    public static ArrayList<ServiceId.Aci> toAciList(Collection<DecryptedMember> membersList) {
        ArrayList<ServiceId.Aci> serviceIdList = new ArrayList<ServiceId.Aci>(membersList.size());
        for (DecryptedMember member : membersList) {
            ServiceId.Aci aci = ServiceIds.ACI.parseOrNull(member.getAciBytes());
            if (aci == null) continue;
            serviceIdList.add(aci);
        }
        return serviceIdList;
    }

    public static Set<ByteString> membersToAciByteStringSet(Collection<DecryptedMember> membersList) {
        HashSet<ByteString> aciList = new HashSet<ByteString>(membersList.size());
        for (DecryptedMember member : membersList) {
            aciList.add(member.getAciBytes());
        }
        return aciList;
    }

    public static ArrayList<ServiceId> pendingToServiceIdList(Collection<DecryptedPendingMember> membersList) {
        ArrayList<ServiceId> serviceIdList = new ArrayList<ServiceId>(membersList.size());
        for (DecryptedPendingMember member : membersList) {
            ServiceId.Aci serviceId = ServiceIds.ACI.parseOrNull(member.getServiceIdBytes());
            if (serviceId == null) continue;
            serviceIdList.add((ServiceId)serviceId);
        }
        return serviceIdList;
    }

    public static ArrayList<ServiceId> removedMembersServiceIdList(DecryptedGroupChange groupChange) {
        List<ByteString> deletedMembers = groupChange.getDeleteMembersList();
        ArrayList<ServiceId> serviceIdList = new ArrayList<ServiceId>(deletedMembers.size());
        for (ByteString member : deletedMembers) {
            ServiceId.Aci serviceId = ServiceIds.ACI.parseOrNull(member);
            if (serviceId == null) continue;
            serviceIdList.add((ServiceId)serviceId);
        }
        return serviceIdList;
    }

    public static ArrayList<ServiceId> removedPendingMembersServiceIdList(DecryptedGroupChange groupChange) {
        List<DecryptedPendingMemberRemoval> deletedPendingMembers = groupChange.getDeletePendingMembersList();
        ArrayList<ServiceId> serviceIdList = new ArrayList<ServiceId>(deletedPendingMembers.size());
        for (DecryptedPendingMemberRemoval member : deletedPendingMembers) {
            ServiceId.Aci serviceId = ServiceIds.ACI.parseOrNull(member.getServiceIdBytes());
            if (serviceId == null) continue;
            serviceIdList.add((ServiceId)serviceId);
        }
        return serviceIdList;
    }

    public static ArrayList<ServiceId> removedRequestingMembersServiceIdList(DecryptedGroupChange groupChange) {
        List<ByteString> deleteRequestingMembers = groupChange.getDeleteRequestingMembersList();
        ArrayList<ServiceId> serviceIdList = new ArrayList<ServiceId>(deleteRequestingMembers.size());
        for (ByteString member : deleteRequestingMembers) {
            ServiceId.Aci serviceId = ServiceIds.ACI.parseOrNull(member);
            if (serviceId == null) continue;
            serviceIdList.add((ServiceId)serviceId);
        }
        return serviceIdList;
    }

    public static Set<ServiceId> bannedMembersToServiceIdSet(Collection<DecryptedBannedMember> membersList) {
        HashSet<ServiceId> serviceIdSet = new HashSet<ServiceId>(membersList.size());
        for (DecryptedBannedMember member : membersList) {
            ServiceId.Aci serviceId = ServiceIds.ACI.parseOrNull(member.getServiceIdBytes());
            if (serviceId == null) continue;
            serviceIdSet.add((ServiceId)serviceId);
        }
        return serviceIdSet;
    }

    public static Optional<ServiceId> editorServiceId(DecryptedGroupChange change) {
        return Optional.ofNullable(change != null ? ServiceIds.ACI.parseOrNull(change.getEditorServiceIdBytes()) : null);
    }

    public static Optional<DecryptedMember> findMemberByAci(Collection<DecryptedMember> members, ServiceId.Aci aci) {
        byte[] aciBytes = aci.toServiceIdBinary();
        for (DecryptedMember member : members) {
            if (!Arrays.equals(aciBytes, member.getAciBytes().toByteArray())) continue;
            return Optional.of(member);
        }
        return Optional.empty();
    }

    public static Optional<DecryptedPendingMember> findPendingByServiceId(Collection<DecryptedPendingMember> members, ServiceId serviceId) {
        byte[] serviceIdBinary = serviceId.toServiceIdBinary();
        for (DecryptedPendingMember member : members) {
            if (!Arrays.equals(serviceIdBinary, member.getServiceIdBytes().toByteArray())) continue;
            return Optional.of(member);
        }
        return Optional.empty();
    }

    public static Optional<DecryptedPendingMember> findPendingByServiceIds(Collection<DecryptedPendingMember> members, ServiceIds serviceIds) {
        for (DecryptedPendingMember member : members) {
            if (!serviceIds.matches(member.getServiceIdBytes())) continue;
            return Optional.of(member);
        }
        return Optional.empty();
    }

    private static int findPendingIndexByServiceIdCipherText(List<DecryptedPendingMember> members, ByteString cipherText) {
        for (int i = 0; i < members.size(); ++i) {
            DecryptedPendingMember member = members.get(i);
            if (!cipherText.equals((Object)member.getServiceIdCipherText())) continue;
            return i;
        }
        return -1;
    }

    private static int findPendingIndexByServiceId(List<DecryptedPendingMember> members, ByteString serviceIdBinary) {
        for (int i = 0; i < members.size(); ++i) {
            DecryptedPendingMember member = members.get(i);
            if (!serviceIdBinary.equals((Object)member.getServiceIdBytes())) continue;
            return i;
        }
        return -1;
    }

    public static Optional<DecryptedRequestingMember> findRequestingByAci(Collection<DecryptedRequestingMember> members, ServiceId.Aci aci) {
        for (DecryptedRequestingMember member : members) {
            if (!Arrays.equals(aci.toServiceIdBinary(), member.getAciBytes().toByteArray())) continue;
            return Optional.of(member);
        }
        return Optional.empty();
    }

    public static Optional<DecryptedRequestingMember> findRequestingByServiceIds(Collection<DecryptedRequestingMember> members, ServiceIds serviceIds) {
        for (DecryptedRequestingMember member : members) {
            if (!serviceIds.matches(member.getAciBytes())) continue;
            return Optional.of(member);
        }
        return Optional.empty();
    }

    public static boolean isPendingOrRequesting(DecryptedGroup group, ServiceIds serviceIds) {
        return DecryptedGroupUtil.findPendingByServiceIds(group.getPendingMembersList(), serviceIds).isPresent() || DecryptedGroupUtil.findRequestingByServiceIds(group.getRequestingMembersList(), serviceIds).isPresent();
    }

    public static boolean isRequesting(DecryptedGroup group, ServiceId.Aci aci) {
        return DecryptedGroupUtil.findRequestingByAci(group.getRequestingMembersList(), aci).isPresent();
    }

    public static DecryptedGroup removeMember(DecryptedGroup group, ServiceId.Aci aci, int revision) {
        DecryptedGroup.Builder builder = DecryptedGroup.newBuilder(group);
        boolean removed = false;
        ArrayList<DecryptedMember> decryptedMembers = new ArrayList<DecryptedMember>(builder.getMembersList());
        Iterator<DecryptedMember> membersList = decryptedMembers.iterator();
        while (membersList.hasNext()) {
            if (!Arrays.equals(aci.toServiceIdBinary(), membersList.next().getAciBytes().toByteArray())) continue;
            membersList.remove();
            removed = true;
        }
        if (removed) {
            return builder.clearMembers().addAllMembers(decryptedMembers).setRevision(revision).build();
        }
        return group;
    }

    public static DecryptedGroup apply(DecryptedGroup group, DecryptedGroupChange change) throws NotAbleToApplyGroupV2ChangeException {
        if (change.getRevision() != group.getRevision() + 1) {
            throw new NotAbleToApplyGroupV2ChangeException();
        }
        return DecryptedGroupUtil.applyWithoutRevisionCheck(group, change);
    }

    public static DecryptedGroup applyWithoutRevisionCheck(DecryptedGroup group, DecryptedGroupChange change) throws NotAbleToApplyGroupV2ChangeException {
        DecryptedGroup.Builder builder = DecryptedGroup.newBuilder(group).setRevision(change.getRevision());
        DecryptedGroupUtil.applyAddMemberAction(builder, change.getNewMembersList());
        DecryptedGroupUtil.applyDeleteMemberActions(builder, change.getDeleteMembersList());
        DecryptedGroupUtil.applyModifyMemberRoleActions(builder, change.getModifyMemberRolesList());
        DecryptedGroupUtil.applyModifyMemberProfileKeyActions(builder, change.getModifiedProfileKeysList());
        DecryptedGroupUtil.applyAddPendingMemberActions(builder, change.getNewPendingMembersList());
        DecryptedGroupUtil.applyDeletePendingMemberActions(builder, change.getDeletePendingMembersList());
        DecryptedGroupUtil.applyPromotePendingMemberActions(builder, change.getPromotePendingMembersList());
        DecryptedGroupUtil.applyModifyTitleAction(builder, change);
        DecryptedGroupUtil.applyModifyDescriptionAction(builder, change);
        DecryptedGroupUtil.applyModifyIsAnnouncementGroupAction(builder, change);
        DecryptedGroupUtil.applyModifyAvatarAction(builder, change);
        DecryptedGroupUtil.applyModifyDisappearingMessagesTimerAction(builder, change);
        DecryptedGroupUtil.applyModifyAttributesAccessControlAction(builder, change);
        DecryptedGroupUtil.applyModifyMembersAccessControlAction(builder, change);
        DecryptedGroupUtil.applyModifyAddFromInviteLinkAccessControlAction(builder, change);
        DecryptedGroupUtil.applyAddRequestingMembers(builder, change.getNewRequestingMembersList());
        DecryptedGroupUtil.applyDeleteRequestingMembers(builder, change.getDeleteRequestingMembersList());
        DecryptedGroupUtil.applyPromoteRequestingMemberActions(builder, change.getPromoteRequestingMembersList());
        DecryptedGroupUtil.applyInviteLinkPassword(builder, change);
        DecryptedGroupUtil.applyAddBannedMembersActions(builder, change.getNewBannedMembersList());
        DecryptedGroupUtil.applyDeleteBannedMembersActions(builder, change.getDeleteBannedMembersList());
        DecryptedGroupUtil.applyPromotePendingPniAciMemberActions(builder, change.getPromotePendingPniAciMembersList());
        return builder.build();
    }

    private static void applyAddMemberAction(DecryptedGroup.Builder builder, List<DecryptedMember> newMembersList) {
        if (newMembersList.isEmpty()) {
            return;
        }
        LinkedHashMap<ByteString, DecryptedMember> members = new LinkedHashMap<ByteString, DecryptedMember>();
        for (DecryptedMember member : builder.getMembersList()) {
            members.put(member.getAciBytes(), member);
        }
        for (DecryptedMember member : newMembersList) {
            members.put(member.getAciBytes(), member);
        }
        builder.clearMembers();
        builder.addAllMembers(members.values());
        DecryptedGroupUtil.removePendingAndRequestingMembersNowInGroup(builder);
    }

    protected static void applyDeleteMemberActions(DecryptedGroup.Builder builder, List<ByteString> deleteMembersList) {
        for (ByteString removedMember : deleteMembersList) {
            int index = DecryptedGroupUtil.indexOfAci(builder.getMembersList(), removedMember);
            if (index == -1) {
                Log.w((String)TAG, (String)"Deleted member on change not found in group");
                continue;
            }
            builder.removeMembers(index);
        }
    }

    private static void applyModifyMemberRoleActions(DecryptedGroup.Builder builder, List<DecryptedModifyMemberRole> modifyMemberRolesList) throws NotAbleToApplyGroupV2ChangeException {
        for (DecryptedModifyMemberRole modifyMemberRole : modifyMemberRolesList) {
            int index = DecryptedGroupUtil.indexOfAci(builder.getMembersList(), modifyMemberRole.getAciBytes());
            if (index == -1) {
                throw new NotAbleToApplyGroupV2ChangeException();
            }
            Member.Role role = modifyMemberRole.getRole();
            DecryptedGroupUtil.ensureKnownRole(role);
            builder.setMembers(index, DecryptedMember.newBuilder(builder.getMembers(index)).setRole(role));
        }
    }

    private static void applyModifyMemberProfileKeyActions(DecryptedGroup.Builder builder, List<DecryptedMember> modifiedProfileKeysList) throws NotAbleToApplyGroupV2ChangeException {
        for (DecryptedMember modifyProfileKey : modifiedProfileKeysList) {
            int index = DecryptedGroupUtil.indexOfAci(builder.getMembersList(), modifyProfileKey.getAciBytes());
            if (index == -1) {
                throw new NotAbleToApplyGroupV2ChangeException();
            }
            builder.setMembers(index, DecryptedGroupUtil.withNewProfileKey(builder.getMembers(index), modifyProfileKey.getProfileKey()));
        }
    }

    private static void applyAddPendingMemberActions(DecryptedGroup.Builder builder, List<DecryptedPendingMember> newPendingMembersList) throws NotAbleToApplyGroupV2ChangeException {
        Set<ByteString> fullMemberSet = DecryptedGroupUtil.getMemberAciSet(builder.getMembersList());
        Set<ByteString> pendingMemberCipherTexts = DecryptedGroupUtil.getPendingMemberCipherTextSet(builder.getPendingMembersList());
        for (DecryptedPendingMember pendingMember : newPendingMembersList) {
            if (fullMemberSet.contains(pendingMember.getServiceIdBytes())) {
                throw new NotAbleToApplyGroupV2ChangeException();
            }
            if (pendingMemberCipherTexts.contains(pendingMember.getServiceIdCipherText())) continue;
            builder.addPendingMembers(pendingMember);
        }
    }

    protected static void applyDeletePendingMemberActions(DecryptedGroup.Builder builder, List<DecryptedPendingMemberRemoval> deletePendingMembersList) {
        for (DecryptedPendingMemberRemoval removedMember : deletePendingMembersList) {
            int index = DecryptedGroupUtil.findPendingIndexByServiceIdCipherText(builder.getPendingMembersList(), removedMember.getServiceIdCipherText());
            if (index == -1) {
                Log.w((String)TAG, (String)"Deleted pending member on change not found in group");
                continue;
            }
            builder.removePendingMembers(index);
        }
    }

    protected static void applyPromotePendingMemberActions(DecryptedGroup.Builder builder, List<DecryptedMember> promotePendingMembersList) throws NotAbleToApplyGroupV2ChangeException {
        for (DecryptedMember newMember : promotePendingMembersList) {
            int index = DecryptedGroupUtil.findPendingIndexByServiceId(builder.getPendingMembersList(), newMember.getAciBytes());
            if (index == -1) {
                throw new NotAbleToApplyGroupV2ChangeException();
            }
            builder.removePendingMembers(index);
            builder.addMembers(newMember);
        }
    }

    protected static void applyModifyTitleAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (change.hasNewTitle()) {
            builder.setTitle(change.getNewTitle().getValue());
        }
    }

    protected static void applyModifyDescriptionAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (change.hasNewDescription()) {
            builder.setDescription(change.getNewDescription().getValue());
        }
    }

    protected static void applyModifyIsAnnouncementGroupAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (change.getNewIsAnnouncementGroup() != EnabledState.UNKNOWN) {
            builder.setIsAnnouncementGroup(change.getNewIsAnnouncementGroup());
        }
    }

    protected static void applyModifyAvatarAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (change.hasNewAvatar()) {
            builder.setAvatar(change.getNewAvatar().getValue());
        }
    }

    protected static void applyModifyDisappearingMessagesTimerAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (change.hasNewTimer()) {
            builder.setDisappearingMessagesTimer(change.getNewTimer());
        }
    }

    protected static void applyModifyAttributesAccessControlAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        AccessControl.AccessRequired newAccessLevel = change.getNewAttributeAccess();
        if (newAccessLevel != AccessControl.AccessRequired.UNKNOWN) {
            builder.setAccessControl(AccessControl.newBuilder(builder.getAccessControl()).setAttributesValue(change.getNewAttributeAccessValue()));
        }
    }

    protected static void applyModifyMembersAccessControlAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        AccessControl.AccessRequired newAccessLevel = change.getNewMemberAccess();
        if (newAccessLevel != AccessControl.AccessRequired.UNKNOWN) {
            builder.setAccessControl(AccessControl.newBuilder(builder.getAccessControl()).setMembersValue(change.getNewMemberAccessValue()));
        }
    }

    protected static void applyModifyAddFromInviteLinkAccessControlAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        AccessControl.AccessRequired newAccessLevel = change.getNewInviteLinkAccess();
        if (newAccessLevel != AccessControl.AccessRequired.UNKNOWN) {
            builder.setAccessControl(AccessControl.newBuilder(builder.getAccessControl()).setAddFromInviteLink(newAccessLevel));
        }
    }

    private static void applyAddRequestingMembers(DecryptedGroup.Builder builder, List<DecryptedRequestingMember> newRequestingMembers) {
        builder.addAllRequestingMembers(newRequestingMembers);
    }

    private static void applyDeleteRequestingMembers(DecryptedGroup.Builder builder, List<ByteString> deleteRequestingMembersList) {
        for (ByteString removedMember : deleteRequestingMembersList) {
            int index = DecryptedGroupUtil.indexOfAciInRequestingList(builder.getRequestingMembersList(), removedMember);
            if (index == -1) {
                Log.w((String)TAG, (String)"Deleted member on change not found in group");
                continue;
            }
            builder.removeRequestingMembers(index);
        }
    }

    private static void applyPromoteRequestingMemberActions(DecryptedGroup.Builder builder, List<DecryptedApproveMember> promoteRequestingMembers) throws NotAbleToApplyGroupV2ChangeException {
        for (DecryptedApproveMember approvedMember : promoteRequestingMembers) {
            int index = DecryptedGroupUtil.indexOfAciInRequestingList(builder.getRequestingMembersList(), approvedMember.getAciBytes());
            if (index == -1) {
                Log.w((String)TAG, (String)"Deleted member on change not found in group");
                continue;
            }
            DecryptedRequestingMember requestingMember = builder.getRequestingMembers(index);
            Member.Role role = approvedMember.getRole();
            DecryptedGroupUtil.ensureKnownRole(role);
            builder.removeRequestingMembers(index).addMembers(DecryptedMember.newBuilder().setAciBytes(approvedMember.getAciBytes()).setProfileKey(requestingMember.getProfileKey()).setRole(role));
        }
    }

    private static void applyInviteLinkPassword(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (!change.getNewInviteLinkPassword().isEmpty()) {
            builder.setInviteLinkPassword(change.getNewInviteLinkPassword());
        }
    }

    private static void applyAddBannedMembersActions(DecryptedGroup.Builder builder, List<DecryptedBannedMember> newBannedMembersList) {
        Set<ByteString> bannedMemberServiceIdSet = DecryptedGroupUtil.getBannedMemberServiceIdSet(builder.getBannedMembersList());
        for (DecryptedBannedMember member : newBannedMembersList) {
            if (bannedMemberServiceIdSet.contains(member.getServiceIdBytes())) {
                Log.w((String)TAG, (String)"Banned member already in banned list");
                continue;
            }
            builder.addBannedMembers(member);
        }
    }

    private static void applyDeleteBannedMembersActions(DecryptedGroup.Builder builder, List<DecryptedBannedMember> deleteMembersList) {
        for (DecryptedBannedMember removedMember : deleteMembersList) {
            int index = DecryptedGroupUtil.indexOfServiceIdInBannedMemberList(builder.getBannedMembersList(), removedMember.getServiceIdBytes());
            if (index == -1) {
                Log.w((String)TAG, (String)"Deleted banned member on change not found in banned list");
                continue;
            }
            builder.removeBannedMembers(index);
        }
    }

    protected static void applyPromotePendingPniAciMemberActions(DecryptedGroup.Builder builder, List<DecryptedMember> promotePendingPniAciMembersList) throws NotAbleToApplyGroupV2ChangeException {
        for (DecryptedMember newMember : promotePendingPniAciMembersList) {
            int index = DecryptedGroupUtil.findPendingIndexByServiceId(builder.getPendingMembersList(), newMember.getPniBytes());
            if (index == -1) {
                throw new NotAbleToApplyGroupV2ChangeException();
            }
            builder.removePendingMembers(index);
            builder.addMembers(newMember);
        }
    }

    private static DecryptedMember withNewProfileKey(DecryptedMember member, ByteString profileKey) {
        return DecryptedMember.newBuilder(member).setProfileKey(profileKey).build();
    }

    private static Set<ByteString> getMemberAciSet(List<DecryptedMember> membersList) {
        HashSet<ByteString> memberAcis = new HashSet<ByteString>(membersList.size());
        for (DecryptedMember members : membersList) {
            memberAcis.add(members.getAciBytes());
        }
        return memberAcis;
    }

    private static Set<ByteString> getPendingMemberCipherTextSet(List<DecryptedPendingMember> pendingMemberList) {
        HashSet<ByteString> pendingMemberCipherTexts = new HashSet<ByteString>(pendingMemberList.size());
        for (DecryptedPendingMember pendingMember : pendingMemberList) {
            pendingMemberCipherTexts.add(pendingMember.getServiceIdCipherText());
        }
        return pendingMemberCipherTexts;
    }

    private static Set<ByteString> getBannedMemberServiceIdSet(List<DecryptedBannedMember> bannedMemberList) {
        HashSet<ByteString> memberServiceIds = new HashSet<ByteString>(bannedMemberList.size());
        for (DecryptedBannedMember member : bannedMemberList) {
            memberServiceIds.add(member.getServiceIdBytes());
        }
        return memberServiceIds;
    }

    private static void removePendingAndRequestingMembersNowInGroup(DecryptedGroup.Builder builder) {
        int i;
        Set<ByteString> allMembers = DecryptedGroupUtil.membersToAciByteStringSet(builder.getMembersList());
        for (i = builder.getPendingMembersCount() - 1; i >= 0; --i) {
            DecryptedPendingMember pendingMember = builder.getPendingMembers(i);
            if (!allMembers.contains(pendingMember.getServiceIdBytes())) continue;
            builder.removePendingMembers(i);
        }
        for (i = builder.getRequestingMembersCount() - 1; i >= 0; --i) {
            DecryptedRequestingMember requestingMember = builder.getRequestingMembers(i);
            if (!allMembers.contains(requestingMember.getAciBytes())) continue;
            builder.removeRequestingMembers(i);
        }
    }

    private static void ensureKnownRole(Member.Role role) throws NotAbleToApplyGroupV2ChangeException {
        if (role != Member.Role.ADMINISTRATOR && role != Member.Role.DEFAULT) {
            throw new NotAbleToApplyGroupV2ChangeException();
        }
    }

    private static int indexOfAci(List<DecryptedMember> memberList, ByteString aci) {
        for (int i = 0; i < memberList.size(); ++i) {
            if (!aci.equals((Object)memberList.get(i).getAciBytes())) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfAciInRequestingList(List<DecryptedRequestingMember> memberList, ByteString aci) {
        for (int i = 0; i < memberList.size(); ++i) {
            if (!aci.equals((Object)memberList.get(i).getAciBytes())) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfServiceIdInBannedMemberList(List<DecryptedBannedMember> memberList, ByteString serviceIdBinary) {
        for (int i = 0; i < memberList.size(); ++i) {
            if (!serviceIdBinary.equals((Object)memberList.get(i).getServiceIdBytes())) continue;
            return i;
        }
        return -1;
    }

    public static boolean changeIsEmpty(DecryptedGroupChange change) {
        return change.getModifiedProfileKeysCount() == 0 && DecryptedGroupUtil.changeIsEmptyExceptForProfileKeyChanges(change);
    }

    public static boolean changeIsEmptyExceptForProfileKeyChanges(DecryptedGroupChange change) {
        return change.getNewMembersCount() == 0 && change.getDeleteMembersCount() == 0 && change.getModifyMemberRolesCount() == 0 && change.getNewPendingMembersCount() == 0 && change.getDeletePendingMembersCount() == 0 && change.getPromotePendingMembersCount() == 0 && !change.hasNewTitle() && !change.hasNewAvatar() && !change.hasNewTimer() && DecryptedGroupUtil.isEmpty(change.getNewAttributeAccess()) && DecryptedGroupUtil.isEmpty(change.getNewMemberAccess()) && DecryptedGroupUtil.isEmpty(change.getNewInviteLinkAccess()) && change.getNewRequestingMembersCount() == 0 && change.getDeleteRequestingMembersCount() == 0 && change.getPromoteRequestingMembersCount() == 0 && change.getNewInviteLinkPassword().size() == 0 && !change.hasNewDescription() && DecryptedGroupUtil.isEmpty(change.getNewIsAnnouncementGroup()) && change.getNewBannedMembersCount() == 0 && change.getDeleteBannedMembersCount() == 0 && change.getPromotePendingPniAciMembersCount() == 0;
    }

    public static boolean changeIsEmptyExceptForBanChangesAndOptionalProfileKeyChanges(DecryptedGroupChange change) {
        return (change.getNewBannedMembersCount() != 0 || change.getDeleteBannedMembersCount() != 0) && change.getNewMembersCount() == 0 && change.getDeleteMembersCount() == 0 && change.getModifyMemberRolesCount() == 0 && change.getNewPendingMembersCount() == 0 && change.getDeletePendingMembersCount() == 0 && change.getPromotePendingMembersCount() == 0 && !change.hasNewTitle() && !change.hasNewAvatar() && !change.hasNewTimer() && DecryptedGroupUtil.isEmpty(change.getNewAttributeAccess()) && DecryptedGroupUtil.isEmpty(change.getNewMemberAccess()) && DecryptedGroupUtil.isEmpty(change.getNewInviteLinkAccess()) && change.getNewRequestingMembersCount() == 0 && change.getDeleteRequestingMembersCount() == 0 && change.getPromoteRequestingMembersCount() == 0 && change.getNewInviteLinkPassword().size() == 0 && !change.hasNewDescription() && DecryptedGroupUtil.isEmpty(change.getNewIsAnnouncementGroup()) && change.getPromotePendingPniAciMembersCount() == 0;
    }

    static boolean isEmpty(AccessControl.AccessRequired newAttributeAccess) {
        return newAttributeAccess == AccessControl.AccessRequired.UNKNOWN;
    }

    static boolean isEmpty(EnabledState enabledState) {
        return enabledState == EnabledState.UNKNOWN;
    }

    public static boolean changeIsSilent(DecryptedGroupChange plainGroupChange) {
        return DecryptedGroupUtil.changeIsEmptyExceptForProfileKeyChanges(plainGroupChange) || DecryptedGroupUtil.changeIsEmptyExceptForBanChangesAndOptionalProfileKeyChanges(plainGroupChange);
    }
}

