/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.protocol.util.ByteUtil;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;

public class UnidentifiedAccess {
    private final byte[] unidentifiedAccessKey;
    private final SenderCertificate unidentifiedCertificate;

    public UnidentifiedAccess(byte[] unidentifiedAccessKey, byte[] unidentifiedCertificate) throws InvalidCertificateException {
        this.unidentifiedAccessKey = unidentifiedAccessKey;
        this.unidentifiedCertificate = new SenderCertificate(unidentifiedCertificate);
    }

    public byte[] getUnidentifiedAccessKey() {
        return this.unidentifiedAccessKey;
    }

    public SenderCertificate getUnidentifiedCertificate() {
        return this.unidentifiedCertificate;
    }

    public static byte[] deriveAccessKeyFrom(ProfileKey profileKey) {
        try {
            byte[] nonce = new byte[12];
            byte[] input = new byte[16];
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)new SecretKeySpec(profileKey.serialize(), "AES"), new GCMParameterSpec(128, nonce));
            byte[] ciphertext = cipher.doFinal(input);
            return ByteUtil.trim((byte[])ciphertext, (int)16);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

