/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import org.signal.libsignal.metadata.InvalidMetadataMessageException;
import org.signal.libsignal.metadata.InvalidMetadataVersionException;
import org.signal.libsignal.metadata.ProtocolDuplicateMessageException;
import org.signal.libsignal.metadata.ProtocolInvalidKeyException;
import org.signal.libsignal.metadata.ProtocolInvalidKeyIdException;
import org.signal.libsignal.metadata.ProtocolInvalidMessageException;
import org.signal.libsignal.metadata.ProtocolInvalidVersionException;
import org.signal.libsignal.metadata.ProtocolLegacyMessageException;
import org.signal.libsignal.metadata.ProtocolNoSessionException;
import org.signal.libsignal.metadata.ProtocolUntrustedIdentityException;
import org.signal.libsignal.metadata.SealedSessionCipher;
import org.signal.libsignal.metadata.SelfSendException;
import org.signal.libsignal.metadata.certificate.CertificateValidator;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.protocol.UnidentifiedSenderMessageContent;
import org.signal.libsignal.protocol.DuplicateMessageException;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidRegistrationIdException;
import org.signal.libsignal.protocol.InvalidSessionException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SessionCipher;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.UntrustedIdentityException;
import org.signal.libsignal.protocol.groups.GroupCipher;
import org.signal.libsignal.protocol.groups.state.SenderKeyStore;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.message.PlaintextContent;
import org.signal.libsignal.protocol.message.PreKeySignalMessage;
import org.signal.libsignal.protocol.message.SignalMessage;
import org.signal.libsignal.protocol.state.SignalProtocolStore;
import org.whispersystems.signalservice.api.InvalidMessageStructureException;
import org.whispersystems.signalservice.api.SignalServiceAccountDataStore;
import org.whispersystems.signalservice.api.SignalSessionLock;
import org.whispersystems.signalservice.api.crypto.ContentHint;
import org.whispersystems.signalservice.api.crypto.EnvelopeContent;
import org.whispersystems.signalservice.api.crypto.EnvelopeMetadata;
import org.whispersystems.signalservice.api.crypto.SignalGroupCipher;
import org.whispersystems.signalservice.api.crypto.SignalSealedSessionCipher;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipherResult;
import org.whispersystems.signalservice.api.crypto.SignalSessionCipher;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;
import org.whispersystems.signalservice.api.messages.SignalServiceMetadata;
import org.whispersystems.signalservice.api.push.OutgoingPushMessage;
import org.whispersystems.signalservice.api.push.PushTransportDetails;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class SignalServiceCipher {
    private static final String TAG = SignalServiceCipher.class.getSimpleName();
    private final SignalServiceAccountDataStore signalProtocolStore;
    private final SignalSessionLock sessionLock;
    private final SignalServiceAddress localAddress;
    private final int localDeviceId;
    private final CertificateValidator certificateValidator;
    private static final Logger LOG = Logger.getLogger(SignalServiceCipher.class.getName());

    public SignalServiceCipher(SignalServiceAddress localAddress, int localDeviceId, SignalServiceAccountDataStore signalProtocolStore, SignalSessionLock sessionLock, CertificateValidator certificateValidator) {
        this.signalProtocolStore = signalProtocolStore;
        this.sessionLock = sessionLock;
        this.localAddress = localAddress;
        this.localDeviceId = localDeviceId;
        this.certificateValidator = certificateValidator;
    }

    public byte[] encryptForGroup(UUID distributionId, List<SignalProtocolAddress> destinations, SenderCertificate senderCertificate, byte[] unpaddedMessage, ContentHint contentHint, Optional<byte[]> groupId) throws NoSessionException, UntrustedIdentityException, InvalidKeyException, InvalidRegistrationIdException {
        PushTransportDetails transport = new PushTransportDetails();
        SignalProtocolAddress localProtocolAddress = new SignalProtocolAddress(this.localAddress.getIdentifier(), this.localDeviceId);
        SignalGroupCipher groupCipher = new SignalGroupCipher(this.sessionLock, new GroupCipher((SenderKeyStore)this.signalProtocolStore, localProtocolAddress));
        SignalSealedSessionCipher sessionCipher = new SignalSealedSessionCipher(this.sessionLock, new SealedSessionCipher((SignalProtocolStore)this.signalProtocolStore, this.localAddress.getServiceId().getRawUUID(), (String)this.localAddress.getNumber().orElse(null), this.localDeviceId));
        CiphertextMessage message = groupCipher.encrypt(distributionId, transport.getPaddedMessageBody(unpaddedMessage));
        UnidentifiedSenderMessageContent messageContent = new UnidentifiedSenderMessageContent(message, senderCertificate, contentHint.getType(), groupId);
        return sessionCipher.multiRecipientEncrypt(destinations, messageContent);
    }

    public OutgoingPushMessage encrypt(SignalProtocolAddress destination, Optional<UnidentifiedAccess> unidentifiedAccess, EnvelopeContent content) throws UntrustedIdentityException, InvalidKeyException {
        try {
            SignalSessionCipher sessionCipher = new SignalSessionCipher(this.sessionLock, new SessionCipher((SignalProtocolStore)this.signalProtocolStore, destination));
            if (unidentifiedAccess.isPresent()) {
                SignalSealedSessionCipher sealedSessionCipher = new SignalSealedSessionCipher(this.sessionLock, new SealedSessionCipher((SignalProtocolStore)this.signalProtocolStore, this.localAddress.getServiceId().getRawUUID(), (String)this.localAddress.getNumber().orElse(null), this.localDeviceId));
                return content.processSealedSender(sessionCipher, sealedSessionCipher, destination, unidentifiedAccess.get().getUnidentifiedCertificate());
            }
            return content.processUnsealedSender(sessionCipher, destination);
        }
        catch (NoSessionException e) {
            e.printStackTrace();
            throw new InvalidSessionException("Session not found.");
        }
    }

    public SignalServiceCipherResult decrypt(SignalServiceProtos.Envelope envelope, long serverDeliveredTimestamp) throws InvalidMetadataMessageException, InvalidMetadataVersionException, ProtocolInvalidKeyIdException, ProtocolLegacyMessageException, ProtocolUntrustedIdentityException, ProtocolNoSessionException, ProtocolInvalidVersionException, ProtocolInvalidMessageException, ProtocolInvalidKeyException, ProtocolDuplicateMessageException, SelfSendException, InvalidMessageStructureException {
        try {
            if (envelope.hasContent()) {
                Plaintext plaintext = this.decryptInternal(envelope, serverDeliveredTimestamp);
                SignalServiceProtos.Content content = SignalServiceProtos.Content.parseFrom(plaintext.getData());
                return new SignalServiceCipherResult(content, new EnvelopeMetadata(plaintext.metadata.getSender().getServiceId(), plaintext.metadata.getSender().getNumber().orElse(null), plaintext.metadata.getSenderDevice(), plaintext.metadata.isNeedsReceipt(), plaintext.metadata.getGroupId().orElse(null), this.localAddress.getServiceId()));
            }
            return null;
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            throw new InvalidMetadataMessageException((Exception)((Object)e));
        }
    }

    private Plaintext decryptInternal(SignalServiceProtos.Envelope envelope, long serverDeliveredTimestamp) throws InvalidMetadataMessageException, InvalidMetadataVersionException, ProtocolDuplicateMessageException, ProtocolUntrustedIdentityException, ProtocolLegacyMessageException, ProtocolInvalidKeyException, ProtocolInvalidVersionException, ProtocolInvalidMessageException, ProtocolInvalidKeyIdException, ProtocolNoSessionException, SelfSendException, InvalidMessageStructureException {
        try {
            SignalServiceMetadata metadata;
            byte[] paddedMessage;
            LOG.info("decryptInternal, envelopeType= " + String.valueOf((Object)envelope.getType()) + " and hasSourceServiceId =" + envelope.hasSourceServiceId() + " and type = " + envelope.getType().getNumber());
            if (!envelope.hasSourceServiceId() && envelope.getType().getNumber() != 6) {
                throw new InvalidMessageStructureException("Non-UD envelope is missing a UUID!");
            }
            if (envelope.getType().getNumber() == 3) {
                sourceAddress = new SignalProtocolAddress(envelope.getSourceServiceId(), envelope.getSourceDevice());
                sessionCipher = new SignalSessionCipher(this.sessionLock, new SessionCipher((SignalProtocolStore)this.signalProtocolStore, sourceAddress));
                paddedMessage = sessionCipher.decrypt(new PreKeySignalMessage(envelope.getContent().toByteArray()));
                metadata = new SignalServiceMetadata(SignalServiceCipher.getSourceAddress(envelope), envelope.getSourceDevice(), envelope.getTimestamp(), envelope.getServerTimestamp(), serverDeliveredTimestamp, false, envelope.getServerGuid(), Optional.empty(), envelope.getDestinationServiceId());
                this.signalProtocolStore.clearSenderKeySharedWith(Collections.singleton(sourceAddress));
            } else if (envelope.getType().getNumber() == 1) {
                sourceAddress = new SignalProtocolAddress(envelope.getSourceServiceId(), envelope.getSourceDevice());
                sessionCipher = new SignalSessionCipher(this.sessionLock, new SessionCipher((SignalProtocolStore)this.signalProtocolStore, sourceAddress));
                paddedMessage = sessionCipher.decrypt(new SignalMessage(envelope.getContent().toByteArray()));
                metadata = new SignalServiceMetadata(SignalServiceCipher.getSourceAddress(envelope), envelope.getSourceDevice(), envelope.getTimestamp(), envelope.getServerTimestamp(), serverDeliveredTimestamp, false, envelope.getServerGuid(), Optional.empty(), envelope.getDestinationServiceId());
            } else if (envelope.getType().getNumber() == 8) {
                paddedMessage = new PlaintextContent(envelope.getContent().toByteArray()).getBody();
                metadata = new SignalServiceMetadata(SignalServiceCipher.getSourceAddress(envelope), envelope.getSourceDevice(), envelope.getTimestamp(), envelope.getServerTimestamp(), serverDeliveredTimestamp, false, envelope.getServerGuid(), Optional.empty(), envelope.getDestinationServiceId());
            } else if (envelope.getType().getNumber() == 6) {
                LOG.info("rawuuid = " + String.valueOf(this.localAddress.getServiceId().getRawUUID()) + " locnr = " + (String)this.localAddress.getNumber().orElse(null) + ", devid = " + this.localDeviceId);
                SignalSealedSessionCipher sealedSessionCipher = new SignalSealedSessionCipher(this.sessionLock, new SealedSessionCipher((SignalProtocolStore)this.signalProtocolStore, this.localAddress.getServiceId().getRawUUID(), (String)this.localAddress.getNumber().orElse(null), this.localDeviceId));
                SealedSessionCipher.DecryptionResult result = sealedSessionCipher.decrypt(this.certificateValidator, envelope.getContent().toByteArray(), envelope.getServerTimestamp());
                SignalServiceAddress resultAddress = new SignalServiceAddress((ServiceId)result.getSenderAci(), result.getSenderE164());
                Optional groupId = result.getGroupId();
                boolean needsReceipt = true;
                if (envelope.hasSourceServiceId()) {
                    Log.w((String)TAG, (String)("[" + envelope.getTimestamp() + "] Received a UD-encrypted message sent over an identified channel. Marking as needsReceipt=false"));
                    needsReceipt = false;
                }
                if (result.getCiphertextMessageType() == 3) {
                    this.signalProtocolStore.clearSenderKeySharedWith(Collections.singleton(new SignalProtocolAddress(result.getSenderUuid(), result.getDeviceId())));
                }
                paddedMessage = result.getPaddedMessage();
                metadata = new SignalServiceMetadata(resultAddress, result.getDeviceId(), envelope.getTimestamp(), envelope.getServerTimestamp(), serverDeliveredTimestamp, needsReceipt, envelope.getServerGuid(), groupId, envelope.getDestinationServiceId());
            } else {
                throw new InvalidMetadataMessageException("Unknown type: " + String.valueOf((Object)envelope.getType()));
            }
            PushTransportDetails transportDetails = new PushTransportDetails();
            byte[] data = transportDetails.getStrippedPaddingMessageBody(paddedMessage);
            return new Plaintext(metadata, data);
        }
        catch (DuplicateMessageException e) {
            throw new ProtocolDuplicateMessageException((Exception)((Object)e), envelope.getSourceServiceId(), envelope.getSourceDevice());
        }
        catch (LegacyMessageException e) {
            throw new ProtocolLegacyMessageException(e, envelope.getSourceServiceId(), envelope.getSourceDevice());
        }
        catch (InvalidMessageException e) {
            throw new ProtocolInvalidMessageException(e, envelope.getSourceServiceId(), envelope.getSourceDevice());
        }
        catch (InvalidKeyIdException e) {
            throw new ProtocolInvalidKeyIdException((Exception)((Object)e), envelope.getSourceServiceId(), envelope.getSourceDevice());
        }
        catch (InvalidKeyException e) {
            throw new ProtocolInvalidKeyException(e, envelope.getSourceServiceId(), envelope.getSourceDevice());
        }
        catch (UntrustedIdentityException e) {
            throw new ProtocolUntrustedIdentityException(e, envelope.getSourceServiceId(), envelope.getSourceDevice());
        }
        catch (InvalidVersionException e) {
            throw new ProtocolInvalidVersionException(e, envelope.getSourceServiceId(), envelope.getSourceDevice());
        }
        catch (NoSessionException e) {
            e.printStackTrace();
            throw new ProtocolNoSessionException(e, envelope.getSourceServiceId(), envelope.getSourceDevice());
        }
    }

    private static SignalServiceAddress getSourceAddress(SignalServiceProtos.Envelope envelope) {
        return new SignalServiceAddress((ServiceId)new ServiceId.Aci(UUID.fromString(envelope.getSourceServiceId())));
    }

    private static class Plaintext {
        private final SignalServiceMetadata metadata;
        private final byte[] data;

        private Plaintext(SignalServiceMetadata metadata, byte[] data) {
            this.metadata = metadata;
            this.data = data;
        }

        public SignalServiceMetadata getMetadata() {
            return this.metadata;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

