/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.signal.libsignal.protocol.util.ByteUtil;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.crypto.InvalidCiphertextException;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;

public class ProfileCipher {
    private static final int NAME_PADDED_LENGTH_1 = 53;
    private static final int NAME_PADDED_LENGTH_2 = 257;
    private static final int ABOUT_PADDED_LENGTH_1 = 128;
    private static final int ABOUT_PADDED_LENGTH_2 = 254;
    private static final int ABOUT_PADDED_LENGTH_3 = 512;
    public static final int MAX_POSSIBLE_NAME_LENGTH = 257;
    public static final int MAX_POSSIBLE_ABOUT_LENGTH = 512;
    public static final int EMOJI_PADDED_LENGTH = 32;
    public static final int ENCRYPTION_OVERHEAD = 28;
    public static final int PAYMENTS_ADDRESS_BASE64_FIELD_SIZE = 776;
    public static final int PAYMENTS_ADDRESS_CONTENT_SIZE = 554;
    private final ProfileKey key;

    public ProfileCipher(ProfileKey key) {
        this.key = key;
    }

    public byte[] encrypt(byte[] input, int paddedLength) {
        try {
            byte[] inputPadded = new byte[paddedLength];
            if (input.length > inputPadded.length) {
                throw new IllegalArgumentException("Input is too long: " + new String(input));
            }
            System.arraycopy(input, 0, inputPadded, 0, input.length);
            byte[] nonce = new byte[12];
            SecureRandom.getInstance("SHA1PRNG").nextBytes(nonce);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)new SecretKeySpec(this.key.serialize(), "AES"), new GCMParameterSpec(128, nonce));
            byte[] encryptedPadded = ByteUtil.combine((byte[][])new byte[][]{nonce, cipher.doFinal(inputPadded)});
            if (encryptedPadded.length != paddedLength + 28) {
                throw new AssertionError((Object)String.format(Locale.US, "Wrong output length %d != padded length %d + %d", encryptedPadded.length, paddedLength, 28));
            }
            return encryptedPadded;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] decrypt(byte[] input) throws InvalidCiphertextException {
        try {
            if (input.length < 29) {
                throw new InvalidCiphertextException("Too short: " + input.length);
            }
            byte[] nonce = new byte[12];
            System.arraycopy(input, 0, nonce, 0, nonce.length);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(this.key.serialize(), "AES"), new GCMParameterSpec(128, nonce));
            return cipher.doFinal(input, nonce.length, input.length - nonce.length);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidKeyException | BadPaddingException e) {
            throw new InvalidCiphertextException(e);
        }
    }

    public byte[] encryptString(String input, int paddedLength) {
        return this.encrypt(input.getBytes(StandardCharsets.UTF_8), paddedLength);
    }

    public String decryptString(byte[] input) throws InvalidCiphertextException {
        byte[] paddedPlaintext = this.decrypt(input);
        int plaintextLength = 0;
        for (int i = paddedPlaintext.length - 1; i >= 0; --i) {
            if (paddedPlaintext[i] == 0) continue;
            plaintextLength = i + 1;
            break;
        }
        byte[] plaintext = new byte[plaintextLength];
        System.arraycopy(paddedPlaintext, 0, plaintext, 0, plaintextLength);
        return new String(plaintext);
    }

    public byte[] encryptBoolean(boolean input) {
        byte[] value = new byte[]{(byte)(input ? 1 : 0)};
        return this.encrypt(value, value.length);
    }

    public Optional<Boolean> decryptBoolean(byte[] input) throws InvalidCiphertextException {
        if (input == null) {
            return Optional.empty();
        }
        byte[] paddedPlaintext = this.decrypt(input);
        return Optional.of(paddedPlaintext[0] != 0);
    }

    public byte[] encryptWithLength(byte[] input, int paddedLength) {
        ByteBuffer content = ByteBuffer.wrap(new byte[input.length + 4]);
        content.order(ByteOrder.LITTLE_ENDIAN);
        content.putInt(input.length);
        content.put(input);
        return this.encrypt(content.array(), paddedLength);
    }

    public byte[] decryptWithLength(byte[] input) throws InvalidCiphertextException, IOException {
        byte[] decrypted = this.decrypt(input);
        int maxLength = decrypted.length - 4;
        ByteBuffer content = ByteBuffer.wrap(decrypted);
        content.order(ByteOrder.LITTLE_ENDIAN);
        int contentLength = content.getInt();
        if (contentLength > maxLength) {
            throw new IOException("Encoded length exceeds content length");
        }
        if (contentLength < 0) {
            throw new IOException("Encoded length is less than 0");
        }
        byte[] result = new byte[contentLength];
        content.get(result);
        return result;
    }

    public boolean verifyUnidentifiedAccess(byte[] theirUnidentifiedAccessVerifier) {
        try {
            if (theirUnidentifiedAccessVerifier == null || theirUnidentifiedAccessVerifier.length == 0) {
                return false;
            }
            byte[] unidentifiedAccessKey = UnidentifiedAccess.deriveAccessKeyFrom(this.key);
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(unidentifiedAccessKey, "HmacSHA256"));
            byte[] ourUnidentifiedAccessVerifier = mac.doFinal(new byte[32]);
            return MessageDigest.isEqual(theirUnidentifiedAccessVerifier, ourUnidentifiedAccessVerifier);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static int getTargetNameLength(String name) {
        int nameLength = name.getBytes(StandardCharsets.UTF_8).length;
        if (nameLength <= 53) {
            return 53;
        }
        return 257;
    }

    public static int getTargetAboutLength(String about) {
        int aboutLength = about.getBytes(StandardCharsets.UTF_8).length;
        if (aboutLength <= 128) {
            return 128;
        }
        if (aboutLength < 254) {
            return 254;
        }
        return 512;
    }
}

