/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.util.Base64;
import java.util.Optional;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.protocol.UnidentifiedSenderMessageContent;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.UntrustedIdentityException;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.message.PlaintextContent;
import org.whispersystems.signalservice.api.crypto.ContentHint;
import org.whispersystems.signalservice.api.crypto.SignalSealedSessionCipher;
import org.whispersystems.signalservice.api.crypto.SignalSessionCipher;
import org.whispersystems.signalservice.api.push.OutgoingPushMessage;
import org.whispersystems.signalservice.api.push.PushTransportDetails;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public interface EnvelopeContent {
    public OutgoingPushMessage processSealedSender(SignalSessionCipher var1, SignalSealedSessionCipher var2, SignalProtocolAddress var3, SenderCertificate var4) throws UntrustedIdentityException, InvalidKeyException, NoSessionException;

    public OutgoingPushMessage processUnsealedSender(SignalSessionCipher var1, SignalProtocolAddress var2) throws UntrustedIdentityException, NoSessionException;

    public int size();

    public Optional<SignalServiceProtos.Content> getContent();

    public static EnvelopeContent encrypted(SignalServiceProtos.Content content, ContentHint contentHint, Optional<byte[]> groupId) {
        return new Encrypted(content, contentHint, groupId);
    }

    public static EnvelopeContent plaintext(PlaintextContent content, Optional<byte[]> groupId) {
        return new Plaintext(content, groupId);
    }

    public static class Encrypted
    implements EnvelopeContent {
        private final SignalServiceProtos.Content content;
        private final ContentHint contentHint;
        private final Optional<byte[]> groupId;

        public Encrypted(SignalServiceProtos.Content content, ContentHint contentHint, Optional<byte[]> groupId) {
            this.content = content;
            this.contentHint = contentHint;
            this.groupId = groupId;
        }

        @Override
        public OutgoingPushMessage processSealedSender(SignalSessionCipher sessionCipher, SignalSealedSessionCipher sealedSessionCipher, SignalProtocolAddress destination, SenderCertificate senderCertificate) throws UntrustedIdentityException, InvalidKeyException, NoSessionException {
            PushTransportDetails transportDetails = new PushTransportDetails();
            CiphertextMessage message = sessionCipher.encrypt(transportDetails.getPaddedMessageBody(this.content.toByteArray()));
            UnidentifiedSenderMessageContent messageContent = new UnidentifiedSenderMessageContent(message, senderCertificate, this.contentHint.getType(), this.groupId);
            byte[] ciphertext = sealedSessionCipher.encrypt(destination, messageContent);
            String body = Base64.getEncoder().encodeToString(ciphertext);
            int remoteRegistrationId = sealedSessionCipher.getRemoteRegistrationId(destination);
            return new OutgoingPushMessage(6, destination.getDeviceId(), remoteRegistrationId, body);
        }

        @Override
        public OutgoingPushMessage processUnsealedSender(SignalSessionCipher sessionCipher, SignalProtocolAddress destination) throws UntrustedIdentityException, NoSessionException {
            PushTransportDetails transportDetails = new PushTransportDetails();
            CiphertextMessage message = sessionCipher.encrypt(transportDetails.getPaddedMessageBody(this.content.toByteArray()));
            int remoteRegistrationId = sessionCipher.getRemoteRegistrationId();
            String body = Base64.getEncoder().encodeToString(message.serialize());
            return new OutgoingPushMessage(switch (message.getType()) {
                case 3 -> 3;
                case 2 -> 1;
                default -> throw new AssertionError((Object)("Bad type: " + message.getType()));
            }, destination.getDeviceId(), remoteRegistrationId, body);
        }

        @Override
        public int size() {
            return this.content.getSerializedSize();
        }

        @Override
        public Optional<SignalServiceProtos.Content> getContent() {
            return Optional.of(this.content);
        }
    }

    public static class Plaintext
    implements EnvelopeContent {
        private final PlaintextContent plaintextContent;
        private final Optional<byte[]> groupId;

        public Plaintext(PlaintextContent plaintextContent, Optional<byte[]> groupId) {
            this.plaintextContent = plaintextContent;
            this.groupId = groupId;
        }

        @Override
        public OutgoingPushMessage processSealedSender(SignalSessionCipher sessionCipher, SignalSealedSessionCipher sealedSessionCipher, SignalProtocolAddress destination, SenderCertificate senderCertificate) throws UntrustedIdentityException, InvalidKeyException {
            UnidentifiedSenderMessageContent messageContent = new UnidentifiedSenderMessageContent((CiphertextMessage)this.plaintextContent, senderCertificate, ContentHint.IMPLICIT.getType(), this.groupId);
            byte[] ciphertext = sealedSessionCipher.encrypt(destination, messageContent);
            String body = Base64.getEncoder().encodeToString(ciphertext);
            int remoteRegistrationId = sealedSessionCipher.getRemoteRegistrationId(destination);
            return new OutgoingPushMessage(6, destination.getDeviceId(), remoteRegistrationId, body);
        }

        @Override
        public OutgoingPushMessage processUnsealedSender(SignalSessionCipher sessionCipher, SignalProtocolAddress destination) {
            String body = Base64.getEncoder().encodeToString(this.plaintextContent.serialize());
            int remoteRegistrationId = sessionCipher.getRemoteRegistrationId();
            return new OutgoingPushMessage(8, destination.getDeviceId(), remoteRegistrationId, body);
        }

        @Override
        public int size() {
            return this.plaintextContent.getBody().length;
        }

        @Override
        public Optional<SignalServiceProtos.Content> getContent() {
            return Optional.empty();
        }
    }
}

