/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import org.signal.libsignal.protocol.kdf.HKDF;
import org.whispersystems.signalservice.api.crypto.CryptoUtil;
import org.whispersystems.signalservice.api.storage.StorageItemKey;
import org.whispersystems.signalservice.api.storage.StorageManifestKey;

public final class StorageKey {
    private static final int LENGTH = 32;
    static final String INFO = "20240801_SIGNAL_STORAGE_SERVICE_ITEM_";
    private final byte[] storageKeyBytes;

    public StorageKey(byte[] key) {
        if (key.length != 32) {
            throw new AssertionError();
        }
        this.storageKeyBytes = key;
    }

    public StorageManifestKey deriveManifestKey(long version) {
        return new StorageManifestKey(this.derive("Manifest_" + version));
    }

    public StorageItemKey deriveItemKey(byte[] key) {
        return this.deriveItemKey(key, new byte[0]);
    }

    public StorageItemKey deriveItemKey(byte[] key, byte[] ikm) {
        if (ikm.length == 0) {
            return new StorageItemKey(this.derive("Item_" + Base64.getEncoder().encodeToString(key)));
        }
        byte[] b0 = INFO.getBytes(StandardCharsets.UTF_8);
        byte[] info = new byte[b0.length + key.length];
        System.arraycopy(b0, 0, info, 0, b0.length);
        System.arraycopy(key, 0, info, b0.length, key.length);
        byte[] derived = HKDF.deriveSecrets((byte[])ikm, (byte[])info, (int)32);
        return new StorageItemKey(derived);
    }

    private byte[] derive(String keyName) {
        return CryptoUtil.hmacSha256(this.storageKeyBytes, keyName.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] serialize() {
        return (byte[])this.storageKeyBytes.clone();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return Arrays.equals(((StorageKey)o).storageKeyBytes, this.storageKeyBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.storageKeyBytes);
    }
}

