/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import java.util.Arrays;
import java.util.Objects;
import org.whispersystems.signalservice.internal.storage.ManifestRecord;

public class StorageId {
    private final int type;
    private final byte[] raw;

    public static StorageId forContact(byte[] raw) {
        return new StorageId(1, raw);
    }

    public static StorageId forGroupV1(byte[] raw) {
        return new StorageId(2, raw);
    }

    public static StorageId forGroupV2(byte[] raw) {
        return new StorageId(3, raw);
    }

    public static StorageId forStoryDistributionList(byte[] raw) {
        return new StorageId(5, raw);
    }

    public static StorageId forAccount(byte[] raw) {
        return new StorageId(4, raw);
    }

    public static StorageId forType(byte[] raw, int type) {
        return new StorageId(type, raw);
    }

    public boolean isUnknown() {
        return !StorageId.isKnownType(this.type);
    }

    private StorageId(int type, byte[] raw) {
        this.type = type;
        this.raw = raw;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public StorageId withNewBytes(byte[] key) {
        return new StorageId(this.type, key);
    }

    public static boolean isKnownType(int val) {
        for (ManifestRecord.Identifier.Type type : ManifestRecord.Identifier.Type.values()) {
            if (type == ManifestRecord.Identifier.Type.UNRECOGNIZED || type.getNumber() != val) continue;
            return true;
        }
        return false;
    }

    public static int largestKnownType() {
        int max = 0;
        for (ManifestRecord.Identifier.Type type : ManifestRecord.Identifier.Type.values()) {
            if (type == ManifestRecord.Identifier.Type.UNRECOGNIZED) continue;
            max = Math.max(type.getNumber(), max);
        }
        return max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageId storageId = (StorageId)o;
        return this.type == storageId.type && Arrays.equals(this.raw, storageId.raw);
    }

    public int hashCode() {
        int result = Objects.hash(this.type);
        result = 31 * result + Arrays.hashCode(this.raw);
        return result;
    }
}

