/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.whispersystems.signalservice.api.Util;
import org.whispersystems.signalservice.api.storage.StorageCipherKey;

public class SignalStorageCipher {
    private static final int IV_LENGTH = 12;

    public static byte[] encrypt(StorageCipherKey key, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] iv = Util.getSecretBytes(12);
            cipher.init(1, (Key)new SecretKeySpec(key.serialize(), "AES"), new GCMParameterSpec(128, iv));
            byte[] ciphertext = cipher.doFinal(data);
            return Util.join(iv, ciphertext);
        }
        catch (InvalidAlgorithmParameterException | java.security.InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] decrypt(StorageCipherKey key, byte[] data) throws InvalidKeyException {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[][] split = Util.split(data, 12, data.length - 12);
            byte[] iv = split[0];
            byte[] cipherText = split[1];
            cipher.init(2, (Key)new SecretKeySpec(key.serialize(), "AES"), new GCMParameterSpec(128, iv));
            return cipher.doFinal(cipherText);
        }
        catch (java.security.InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidKeyException((Throwable)e);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

