/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentPointer;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentStream;

public abstract class SignalServiceAttachment {
    private final String contentType;

    protected SignalServiceAttachment(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public abstract boolean isStream();

    public abstract boolean isPointer();

    public SignalServiceAttachmentStream asStream() {
        return (SignalServiceAttachmentStream)this;
    }

    public SignalServiceAttachmentPointer asPointer() {
        return (SignalServiceAttachmentPointer)this;
    }

    public static Builder newStreamBuilder() {
        return new Builder();
    }

    public static SignalServiceAttachmentStream emptyStream(String contentType) {
        return new SignalServiceAttachmentStream(new ByteArrayInputStream(new byte[0]), contentType, 0L, Optional.empty(), false, false, false, false, null);
    }

    public static class Builder {
        private InputStream inputStream;
        private String contentType;
        private String fileName;
        private long length;
        private ProgressListener listener;
        private boolean voiceNote;
        private boolean borderless;
        private boolean gif;
        private boolean faststart;
        private int width;
        private int height;
        private String caption;
        private String blurHash;
        private long uploadTimestamp;

        private Builder() {
        }

        public Builder withStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder withLength(long length) {
            this.length = length;
            return this;
        }

        public Builder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder withListener(ProgressListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder withVoiceNote(boolean voiceNote) {
            this.voiceNote = voiceNote;
            return this;
        }

        public Builder withBorderless(boolean borderless) {
            this.borderless = borderless;
            return this;
        }

        public Builder withGif(boolean gif) {
            this.gif = gif;
            return this;
        }

        public Builder withFaststart(boolean faststart) {
            this.faststart = faststart;
            return this;
        }

        public Builder withWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder withHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder withCaption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder withBlurHash(String blurHash) {
            this.blurHash = blurHash;
            return this;
        }

        public Builder withUploadTimestamp(long uploadTimestamp) {
            this.uploadTimestamp = uploadTimestamp;
            return this;
        }

        public SignalServiceAttachmentStream build() {
            if (this.inputStream == null) {
                throw new IllegalArgumentException("Must specify stream!");
            }
            if (this.contentType == null) {
                throw new IllegalArgumentException("No content type specified!");
            }
            if (this.length == 0L) {
                throw new IllegalArgumentException("No length specified!");
            }
            return new SignalServiceAttachmentStream(this.inputStream, this.contentType, this.length, Optional.ofNullable(this.fileName), this.voiceNote, this.borderless, this.gif, this.faststart, Optional.empty(), this.width, this.height, this.uploadTimestamp, Optional.ofNullable(this.caption), Optional.ofNullable(this.blurHash), this.listener);
        }
    }

    public static interface ProgressListener {
        public void onAttachmentProgress(long var1, long var3);
    }
}

