/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.groupsv2;

import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.List;
import org.signal.storageservice.protos.groups.GroupChange;
import org.signal.storageservice.protos.groups.local.DecryptedApproveMember;
import org.signal.storageservice.protos.groups.local.DecryptedBannedMember;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.protos.groups.local.DecryptedMember;
import org.signal.storageservice.protos.groups.local.DecryptedModifyMemberRole;
import org.signal.storageservice.protos.groups.local.DecryptedPendingMember;
import org.signal.storageservice.protos.groups.local.DecryptedPendingMemberRemoval;
import org.signal.storageservice.protos.groups.local.DecryptedRequestingMember;
import org.whispersystems.signalservice.api.groupsv2.ChangeSetModifier;
import org.whispersystems.signalservice.api.groupsv2.DecryptedGroupChangeActionsBuilderChangeSetModifier;
import org.whispersystems.signalservice.api.groupsv2.GroupChangeActionsBuilderChangeSetModifier;

public final class GroupChangeUtil {
    private GroupChangeUtil() {
    }

    public static boolean changeIsEmpty(GroupChange.Actions change) {
        return change.getAddMembersCount() == 0 && change.getDeleteMembersCount() == 0 && change.getModifyMemberRolesCount() == 0 && change.getModifyMemberProfileKeysCount() == 0 && change.getAddPendingMembersCount() == 0 && change.getDeletePendingMembersCount() == 0 && change.getPromotePendingMembersCount() == 0 && !change.hasModifyTitle() && !change.hasModifyAvatar() && !change.hasModifyDisappearingMessagesTimer() && !change.hasModifyAttributesAccess() && !change.hasModifyMemberAccess() && !change.hasModifyAddFromInviteLinkAccess() && change.getAddRequestingMembersCount() == 0 && change.getDeleteRequestingMembersCount() == 0 && change.getPromoteRequestingMembersCount() == 0 && !change.hasModifyInviteLinkPassword() && !change.hasModifyDescription() && !change.hasModifyAnnouncementsOnly() && change.getAddBannedMembersCount() == 0 && change.getDeleteBannedMembersCount() == 0 && change.getPromotePendingPniAciMembersCount() == 0;
    }

    public static GroupChange.Actions.Builder resolveConflict(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, GroupChange.Actions encryptedChange) {
        GroupChange.Actions.Builder result = GroupChange.Actions.newBuilder(encryptedChange);
        GroupChangeUtil.resolveConflict(groupState, conflictingChange, new GroupChangeActionsBuilderChangeSetModifier(result));
        return result;
    }

    public static DecryptedGroupChange.Builder resolveConflict(DecryptedGroup groupState, DecryptedGroupChange conflictingChange) {
        DecryptedGroupChange.Builder result = DecryptedGroupChange.newBuilder(conflictingChange);
        GroupChangeUtil.resolveConflict(groupState, conflictingChange, new DecryptedGroupChangeActionsBuilderChangeSetModifier(result));
        return result;
    }

    private static void resolveConflict(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier changeSetModifier) {
        HashMap<ByteString, DecryptedMember> fullMembersByUuid = new HashMap<ByteString, DecryptedMember>(groupState.getMembersCount());
        HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId = new HashMap<ByteString, DecryptedPendingMember>(groupState.getPendingMembersCount());
        HashMap<ByteString, DecryptedRequestingMember> requestingMembersByUuid = new HashMap<ByteString, DecryptedRequestingMember>(groupState.getMembersCount());
        HashMap<ByteString, DecryptedBannedMember> bannedMembersByServiceId = new HashMap<ByteString, DecryptedBannedMember>(groupState.getBannedMembersCount());
        for (DecryptedMember decryptedMember : groupState.getMembersList()) {
            fullMembersByUuid.put(decryptedMember.getAciBytes(), decryptedMember);
        }
        for (DecryptedPendingMember decryptedPendingMember : groupState.getPendingMembersList()) {
            pendingMembersByServiceId.put(decryptedPendingMember.getServiceIdBytes(), decryptedPendingMember);
        }
        for (DecryptedRequestingMember decryptedRequestingMember : groupState.getRequestingMembersList()) {
            requestingMembersByUuid.put(decryptedRequestingMember.getAciBytes(), decryptedRequestingMember);
        }
        for (DecryptedBannedMember decryptedBannedMember : groupState.getBannedMembersList()) {
            bannedMembersByServiceId.put(decryptedBannedMember.getServiceIdBytes(), decryptedBannedMember);
        }
        GroupChangeUtil.resolveField3AddMembers(conflictingChange, changeSetModifier, fullMembersByUuid, pendingMembersByServiceId);
        GroupChangeUtil.resolveField4DeleteMembers(conflictingChange, changeSetModifier, fullMembersByUuid);
        GroupChangeUtil.resolveField5ModifyMemberRoles(conflictingChange, changeSetModifier, fullMembersByUuid);
        GroupChangeUtil.resolveField6ModifyProfileKeys(conflictingChange, changeSetModifier, fullMembersByUuid);
        GroupChangeUtil.resolveField7AddPendingMembers(conflictingChange, changeSetModifier, fullMembersByUuid, pendingMembersByServiceId);
        GroupChangeUtil.resolveField8DeletePendingMembers(conflictingChange, changeSetModifier, pendingMembersByServiceId);
        GroupChangeUtil.resolveField9PromotePendingMembers(conflictingChange, changeSetModifier, pendingMembersByServiceId);
        GroupChangeUtil.resolveField10ModifyTitle(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField11ModifyAvatar(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField12modifyDisappearingMessagesTimer(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField13modifyAttributesAccess(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField14modifyAttributesAccess(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField15modifyAddFromInviteLinkAccess(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField16AddRequestingMembers(conflictingChange, changeSetModifier, fullMembersByUuid, pendingMembersByServiceId);
        GroupChangeUtil.resolveField17DeleteMembers(conflictingChange, changeSetModifier, requestingMembersByUuid);
        GroupChangeUtil.resolveField18PromoteRequestingMembers(conflictingChange, changeSetModifier, requestingMembersByUuid);
        GroupChangeUtil.resolveField20ModifyDescription(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField21ModifyAnnouncementsOnly(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField22AddBannedMembers(conflictingChange, changeSetModifier, bannedMembersByServiceId);
        GroupChangeUtil.resolveField23DeleteBannedMembers(conflictingChange, changeSetModifier, bannedMembersByServiceId);
        GroupChangeUtil.resolveField24PromotePendingPniAciMembers(conflictingChange, changeSetModifier, fullMembersByUuid);
    }

    private static void resolveField3AddMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedMember> fullMembersByUuid, HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId) {
        List<DecryptedMember> newMembersList = conflictingChange.getNewMembersList();
        for (int i = newMembersList.size() - 1; i >= 0; --i) {
            DecryptedMember member = newMembersList.get(i);
            if (fullMembersByUuid.containsKey(member.getAciBytes())) {
                result.removeAddMembers(i);
                continue;
            }
            if (!pendingMembersByServiceId.containsKey(member.getAciBytes()) && !pendingMembersByServiceId.containsKey(member.getPniBytes())) continue;
            result.moveAddToPromote(i);
        }
    }

    private static void resolveField4DeleteMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedMember> fullMembersByUuid) {
        List<ByteString> deletedMembersList = conflictingChange.getDeleteMembersList();
        for (int i = deletedMembersList.size() - 1; i >= 0; --i) {
            ByteString member = deletedMembersList.get(i);
            if (fullMembersByUuid.containsKey(member)) continue;
            result.removeDeleteMembers(i);
        }
    }

    private static void resolveField5ModifyMemberRoles(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedMember> fullMembersByUuid) {
        List<DecryptedModifyMemberRole> modifyRolesList = conflictingChange.getModifyMemberRolesList();
        for (int i = modifyRolesList.size() - 1; i >= 0; --i) {
            DecryptedModifyMemberRole modifyRoleAction = modifyRolesList.get(i);
            DecryptedMember memberInGroup = fullMembersByUuid.get(modifyRoleAction.getAciBytes());
            if (memberInGroup != null && memberInGroup.getRole() != modifyRoleAction.getRole()) continue;
            result.removeModifyMemberRoles(i);
        }
    }

    private static void resolveField6ModifyProfileKeys(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedMember> fullMembersByUuid) {
        List<DecryptedMember> modifyProfileKeysList = conflictingChange.getModifiedProfileKeysList();
        for (int i = modifyProfileKeysList.size() - 1; i >= 0; --i) {
            DecryptedMember member = modifyProfileKeysList.get(i);
            DecryptedMember memberInGroup = fullMembersByUuid.get(member.getAciBytes());
            if (memberInGroup != null && !member.getProfileKey().equals((Object)memberInGroup.getProfileKey())) continue;
            result.removeModifyMemberProfileKeys(i);
        }
    }

    private static void resolveField7AddPendingMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedMember> fullMembersByUuid, HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId) {
        List<DecryptedPendingMember> newPendingMembersList = conflictingChange.getNewPendingMembersList();
        for (int i = newPendingMembersList.size() - 1; i >= 0; --i) {
            DecryptedPendingMember member = newPendingMembersList.get(i);
            if (!fullMembersByUuid.containsKey(member.getServiceIdBytes()) && !pendingMembersByServiceId.containsKey(member.getServiceIdBytes())) continue;
            result.removeAddPendingMembers(i);
        }
    }

    private static void resolveField8DeletePendingMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId) {
        List<DecryptedPendingMemberRemoval> deletePendingMembersList = conflictingChange.getDeletePendingMembersList();
        for (int i = deletePendingMembersList.size() - 1; i >= 0; --i) {
            DecryptedPendingMemberRemoval member = deletePendingMembersList.get(i);
            if (pendingMembersByServiceId.containsKey(member.getServiceIdBytes())) continue;
            result.removeDeletePendingMembers(i);
        }
    }

    private static void resolveField9PromotePendingMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId) {
        List<DecryptedMember> promotePendingMembersList = conflictingChange.getPromotePendingMembersList();
        for (int i = promotePendingMembersList.size() - 1; i >= 0; --i) {
            DecryptedMember member = promotePendingMembersList.get(i);
            if (pendingMembersByServiceId.containsKey(member.getAciBytes()) || pendingMembersByServiceId.containsKey(member.getPniBytes())) continue;
            result.removePromotePendingMembers(i);
        }
    }

    private static void resolveField10ModifyTitle(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result) {
        if (conflictingChange.hasNewTitle() && conflictingChange.getNewTitle().getValue().equals(groupState.getTitle())) {
            result.clearModifyTitle();
        }
    }

    private static void resolveField11ModifyAvatar(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result) {
        if (conflictingChange.hasNewAvatar() && conflictingChange.getNewAvatar().getValue().equals(groupState.getAvatar())) {
            result.clearModifyAvatar();
        }
    }

    private static void resolveField12modifyDisappearingMessagesTimer(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result) {
        if (conflictingChange.hasNewTimer() && conflictingChange.getNewTimer().getDuration() == groupState.getDisappearingMessagesTimer().getDuration()) {
            result.clearModifyDisappearingMessagesTimer();
        }
    }

    private static void resolveField13modifyAttributesAccess(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result) {
        if (conflictingChange.getNewAttributeAccess() == groupState.getAccessControl().getAttributes()) {
            result.clearModifyAttributesAccess();
        }
    }

    private static void resolveField14modifyAttributesAccess(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result) {
        if (conflictingChange.getNewMemberAccess() == groupState.getAccessControl().getMembers()) {
            result.clearModifyMemberAccess();
        }
    }

    private static void resolveField15modifyAddFromInviteLinkAccess(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result) {
        if (conflictingChange.getNewInviteLinkAccess() == groupState.getAccessControl().getAddFromInviteLink()) {
            result.clearModifyAddFromInviteLinkAccess();
        }
    }

    private static void resolveField16AddRequestingMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedMember> fullMembersByUuid, HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId) {
        List<DecryptedRequestingMember> newMembersList = conflictingChange.getNewRequestingMembersList();
        for (int i = newMembersList.size() - 1; i >= 0; --i) {
            DecryptedRequestingMember member = newMembersList.get(i);
            if (fullMembersByUuid.containsKey(member.getAciBytes())) {
                result.removeAddRequestingMembers(i);
                continue;
            }
            if (!pendingMembersByServiceId.containsKey(member.getAciBytes())) continue;
            result.moveAddRequestingMembersToPromote(i);
        }
    }

    private static void resolveField17DeleteMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedRequestingMember> requestingMembers) {
        List<ByteString> deletedMembersList = conflictingChange.getDeleteRequestingMembersList();
        for (int i = deletedMembersList.size() - 1; i >= 0; --i) {
            ByteString member = deletedMembersList.get(i);
            if (requestingMembers.containsKey(member)) continue;
            result.removeDeleteRequestingMembers(i);
        }
    }

    private static void resolveField18PromoteRequestingMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedRequestingMember> requestingMembersByUuid) {
        List<DecryptedApproveMember> promoteRequestingMembersList = conflictingChange.getPromoteRequestingMembersList();
        for (int i = promoteRequestingMembersList.size() - 1; i >= 0; --i) {
            DecryptedApproveMember member = promoteRequestingMembersList.get(i);
            if (requestingMembersByUuid.containsKey(member.getAciBytes())) continue;
            result.removePromoteRequestingMembers(i);
        }
    }

    private static void resolveField20ModifyDescription(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result) {
        if (conflictingChange.hasNewDescription() && conflictingChange.getNewDescription().getValue().equals(groupState.getDescription())) {
            result.clearModifyDescription();
        }
    }

    private static void resolveField21ModifyAnnouncementsOnly(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result) {
        if (conflictingChange.getNewIsAnnouncementGroup().equals((Object)groupState.getIsAnnouncementGroup())) {
            result.clearModifyAnnouncementsOnly();
        }
    }

    private static void resolveField22AddBannedMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedBannedMember> bannedMembersByServiceId) {
        List<DecryptedBannedMember> newBannedMembersList = conflictingChange.getNewBannedMembersList();
        for (int i = newBannedMembersList.size() - 1; i >= 0; --i) {
            DecryptedBannedMember member = newBannedMembersList.get(i);
            if (!bannedMembersByServiceId.containsKey(member.getServiceIdBytes())) continue;
            result.removeAddBannedMembers(i);
        }
    }

    private static void resolveField23DeleteBannedMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedBannedMember> bannedMembersByServiceId) {
        List<DecryptedBannedMember> deleteBannedMembersList = conflictingChange.getDeleteBannedMembersList();
        for (int i = deleteBannedMembersList.size() - 1; i >= 0; --i) {
            DecryptedBannedMember member = deleteBannedMembersList.get(i);
            if (bannedMembersByServiceId.containsKey(member.getServiceIdBytes())) continue;
            result.removeDeleteBannedMembers(i);
        }
    }

    private static void resolveField24PromotePendingPniAciMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result, HashMap<ByteString, DecryptedMember> fullMembersByAci) {
        List<DecryptedMember> promotePendingPniAciMembersList = conflictingChange.getPromotePendingPniAciMembersList();
        for (int i = promotePendingPniAciMembersList.size() - 1; i >= 0; --i) {
            DecryptedMember member = promotePendingPniAciMembersList.get(i);
            if (!fullMembersByAci.containsKey(member.getAciBytes())) continue;
            result.removePromotePendingPniAciMembers(i);
        }
    }
}

