/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import org.signal.libsignal.protocol.DuplicateMessageException;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.SessionCipher;
import org.signal.libsignal.protocol.UntrustedIdentityException;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.message.PreKeySignalMessage;
import org.signal.libsignal.protocol.message.SignalMessage;
import org.whispersystems.signalservice.api.SignalSessionLock;

public class SignalSessionCipher {
    private final SignalSessionLock lock;
    private final SessionCipher cipher;

    public SignalSessionCipher(SignalSessionLock lock, SessionCipher cipher) {
        this.lock = lock;
        this.cipher = cipher;
    }

    public CiphertextMessage encrypt(byte[] paddedMessage) throws UntrustedIdentityException, NoSessionException {
        try (SignalSessionLock.Lock unused = this.lock.acquire();){
            CiphertextMessage ciphertextMessage = this.cipher.encrypt(paddedMessage);
            return ciphertextMessage;
        }
    }

    public byte[] decrypt(PreKeySignalMessage ciphertext) throws DuplicateMessageException, LegacyMessageException, InvalidMessageException, InvalidKeyIdException, InvalidKeyException, UntrustedIdentityException {
        try (SignalSessionLock.Lock unused = this.lock.acquire();){
            byte[] byArray = this.cipher.decrypt(ciphertext);
            return byArray;
        }
    }

    public byte[] decrypt(SignalMessage ciphertext) throws InvalidMessageException, DuplicateMessageException, LegacyMessageException, NoSessionException, UntrustedIdentityException, InvalidVersionException {
        try (SignalSessionLock.Lock unused = this.lock.acquire();){
            byte[] byArray = this.cipher.decrypt(ciphertext);
            return byArray;
        }
    }

    public int getRemoteRegistrationId() {
        try (SignalSessionLock.Lock unused = this.lock.acquire();){
            int n = this.cipher.getRemoteRegistrationId();
            return n;
        }
    }

    public int getSessionVersion() {
        try (SignalSessionLock.Lock unused = this.lock.acquire();){
            int n = this.cipher.getSessionVersion();
            return n;
        }
    }
}

