/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InputStreamUtil {
    public static byte[] join(byte[] ... input) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (byte[] part : input) {
                baos.write(part);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String join(Collection<String> list, String delimiter) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (String item : list) {
            result.append(item);
            if (++i >= list.size()) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static byte[][] split(byte[] input, int firstLength, int secondLength) {
        byte[][] parts = new byte[2][];
        parts[0] = new byte[firstLength];
        System.arraycopy(input, 0, parts[0], 0, firstLength);
        parts[1] = new byte[secondLength];
        System.arraycopy(input, firstLength, parts[1], 0, secondLength);
        return parts;
    }

    public static byte[] trim(byte[] input, int length) {
        byte[] result = new byte[length];
        System.arraycopy(input, 0, result, 0, result.length);
        return result;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static byte[] getSecretBytes(int size) {
        try {
            byte[] secret = new byte[size];
            SecureRandom.getInstance("SHA1PRNG").nextBytes(secret);
            return secret;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] getRandomLengthBytes(int maxSize) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] result = new byte[secureRandom.nextInt(maxSize) + 1];
        secureRandom.nextBytes(result);
        return result;
    }

    public static String readFully(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            bout.write(buffer, 0, read);
        }
        in.close();
        return new String(bout.toByteArray());
    }

    public static void readFully(InputStream in, byte[] buffer) throws IOException {
        int read;
        int offset = 0;
        while ((read = in.read(buffer, offset, buffer.length - offset)) + offset < buffer.length) {
            offset += read;
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        in.close();
        out.close();
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Object lock, long millis) {
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait(millis);
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static int toIntExact(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    public static <T> List<T> immutableList(T ... elements) {
        return Collections.unmodifiableList(Arrays.asList((Object[])elements.clone()));
    }

    public static int parseInt(String integer, int defaultValue) {
        try {
            return Integer.parseInt(integer);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long parseLong(String longString, long defaultValue) {
        try {
            return Long.parseLong(longString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

