/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class Curve {
    public static ECPrivateKey decodePrivatePoint(byte[] bytes) throws InvalidKeyException {
        return new ECPrivateKey(bytes);
    }

    public static ECKeyPair generateKeyPair() {
        ECPrivateKey privateKey = ECPrivateKey.generate();
        ECPublicKey publicKey = privateKey.publicKey();
        return new ECKeyPair(publicKey, privateKey);
    }

    public static byte[] calculateAgreement(ECPublicKey publicKey, ECPrivateKey privateKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("public value is null");
        }
        if (privateKey == null) {
            throw new InvalidKeyException("private value is null");
        }
        return privateKey.calculateAgreement(publicKey);
    }

    public static byte[] calculateSignature(ECPrivateKey signingKey, byte[] message) throws InvalidKeyException {
        if (signingKey == null || message == null) {
            throw new InvalidKeyException("Values must not be null");
        }
        return signingKey.calculateSignature(message);
    }

    public static ECPublicKey decodePoint(byte[] bytes, int offset) throws InvalidKeyException {
        if (bytes == null || bytes.length - offset < 1) {
            throw new InvalidKeyException("No key type identifier");
        }
        return new ECPublicKey(bytes, offset);
    }
}

