/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.signal.libsignal.protocol.InvalidMacException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.kdf.HKDF;
import org.whispersystems.signalservice.api.crypto.InputStreamUtil;

public class AttachmentCipherInputStream
extends FilterInputStream {
    static final Logger LOG = Logger.getLogger(AttachmentCipherInputStream.class.getName());
    private static final int BLOCK_SIZE = 16;
    private static final int CIPHER_KEY_SIZE = 32;
    private static final int MAC_KEY_SIZE = 32;
    private Cipher cipher;
    private boolean done;
    private long totalDataSize;
    private long totalRead;
    private byte[] overflowBuffer;

    public static InputStream createForAttachment(InputStream encryptedStream, long encryptedLength, int unencryptedLength, long plaintextLength, byte[] combinedKeyMaterial) throws InvalidMessageException, IOException {
        try {
            LOG.info("Create for att");
            byte[][] parts = InputStreamUtil.split(combinedKeyMaterial, 32, 32);
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(parts[1], "HmacSHA256"));
            if (encryptedLength <= (long)(16 + mac.getMacLength())) {
                throw new InvalidMessageException("Message shorter than crypto overhead!");
            }
            FilterInputStream inputStream = new AttachmentCipherInputStream(encryptedStream, parts[0], encryptedLength - 16L - (long)mac.getMacLength());
            if (plaintextLength != 0L) {
                inputStream = new ContentLengthInputStream(inputStream, plaintextLength);
            }
            return inputStream;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static InputStream createForAttachment(File file, long plaintextLength, byte[] combinedKeyMaterial, byte[] digest) throws InvalidMessageException, IOException {
        try {
            LOG.info("Create for " + String.valueOf(file) + " with ptl = " + plaintextLength + ", digest = " + String.valueOf(digest));
            byte[][] parts = InputStreamUtil.split(combinedKeyMaterial, 32, 32);
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(parts[1], "HmacSHA256"));
            if (file.length() <= (long)(16 + mac.getMacLength())) {
                throw new InvalidMessageException("Message shorter than crypto overhead!");
            }
            try (FileInputStream fin = new FileInputStream(file);){
                AttachmentCipherInputStream.verifyMac(fin, file.length(), mac, digest);
            }
            FilterInputStream inputStream = new AttachmentCipherInputStream(new FileInputStream(file), parts[0], file.length() - 16L - (long)mac.getMacLength());
            if (plaintextLength != 0L) {
                inputStream = new ContentLengthInputStream(inputStream, plaintextLength);
            }
            LOG.info("And return " + String.valueOf(inputStream));
            return inputStream;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            LOG.log(Level.SEVERE, "OOPS", e);
            e.printStackTrace();
            throw new AssertionError((Object)e);
        }
        catch (InvalidMacException e) {
            LOG.log(Level.SEVERE, "OOPS", e);
            e.printStackTrace();
            throw new InvalidMessageException((Throwable)e);
        }
    }

    public static InputStream createForStickerData(byte[] data, byte[] packKey) throws InvalidMessageException, IOException {
        try {
            byte[] combinedKeyMaterial = HKDF.deriveSecrets((byte[])packKey, (byte[])"Sticker Pack".getBytes(), (int)64);
            byte[][] parts = InputStreamUtil.split(combinedKeyMaterial, 32, 32);
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(parts[1], "HmacSHA256"));
            if (data.length <= 16 + mac.getMacLength()) {
                throw new InvalidMessageException("Message shorter than crypto overhead!");
            }
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
                AttachmentCipherInputStream.verifyMac(inputStream, data.length, mac, null);
            }
            return new AttachmentCipherInputStream(new ByteArrayInputStream(data), parts[0], data.length - 16 - mac.getMacLength());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidMacException e) {
            throw new InvalidMessageException((Throwable)e);
        }
    }

    private AttachmentCipherInputStream(InputStream inputStream, byte[] cipherKey, long totalDataSize) throws IOException {
        super(inputStream);
        try {
            byte[] iv = new byte[16];
            this.readFully(iv);
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.cipher.init(2, (Key)new SecretKeySpec(cipherKey, "AES"), new IvParameterSpec(iv));
            this.done = false;
            this.totalRead = 0L;
            this.totalDataSize = totalDataSize;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.totalRead != this.totalDataSize) {
            return this.readIncremental(buffer, offset, length);
        }
        if (!this.done) {
            return this.readFinal(buffer, offset, length);
        }
        return -1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        long skipped;
        int read;
        for (skipped = 0L; skipped < byteCount; skipped += (long)read) {
            byte[] buf = new byte[Math.min(4096, (int)(byteCount - skipped))];
            read = this.read(buf);
        }
        return skipped;
    }

    private int readFinal(byte[] buffer, int offset, int length) throws IOException {
        try {
            int flourish = this.cipher.doFinal(buffer, offset);
            this.done = true;
            return flourish;
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new IOException(e);
        }
    }

    private int readIncremental(byte[] buffer, int offset, int length) throws IOException {
        byte[] internalBuffer;
        int readLength = 0;
        if (null != this.overflowBuffer) {
            if (this.overflowBuffer.length > length) {
                System.arraycopy(this.overflowBuffer, 0, buffer, offset, length);
                this.overflowBuffer = Arrays.copyOfRange(this.overflowBuffer, length, this.overflowBuffer.length);
                return length;
            }
            if (this.overflowBuffer.length == length) {
                System.arraycopy(this.overflowBuffer, 0, buffer, offset, length);
                this.overflowBuffer = null;
                return length;
            }
            System.arraycopy(this.overflowBuffer, 0, buffer, offset, this.overflowBuffer.length);
            offset += (readLength += this.overflowBuffer.length);
            length -= readLength;
            this.overflowBuffer = null;
        }
        if ((long)length + this.totalRead > this.totalDataSize) {
            length = (int)(this.totalDataSize - this.totalRead);
        }
        int read = super.read(internalBuffer, 0, (internalBuffer = new byte[length]).length <= this.cipher.getBlockSize() ? internalBuffer.length : internalBuffer.length - this.cipher.getBlockSize());
        this.totalRead += (long)read;
        try {
            int outputLen = this.cipher.getOutputSize(read);
            if (outputLen <= length) {
                return readLength += this.cipher.update(internalBuffer, 0, read, buffer, offset);
            }
            byte[] transientBuffer = new byte[outputLen];
            if ((outputLen = this.cipher.update(internalBuffer, 0, read, transientBuffer, 0)) <= length) {
                System.arraycopy(transientBuffer, 0, buffer, offset, outputLen);
                readLength += outputLen;
            } else {
                System.arraycopy(transientBuffer, 0, buffer, offset, length);
                this.overflowBuffer = Arrays.copyOfRange(transientBuffer, length, outputLen);
                readLength += length;
            }
            return readLength;
        }
        catch (ShortBufferException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void verifyMac(InputStream inputStream, long length, Mac mac, byte[] theirDigest) throws InvalidMacException {
        try {
            int read;
            MessageDigest digest = MessageDigest.getInstance("SHA256");
            byte[] buffer = new byte[4096];
            for (int remainingData = InputStreamUtil.toIntExact(length) - mac.getMacLength(); remainingData > 0; remainingData -= read) {
                read = inputStream.read(buffer, 0, Math.min(buffer.length, remainingData));
                mac.update(buffer, 0, read);
                digest.update(buffer, 0, read);
            }
            byte[] ourMac = mac.doFinal();
            byte[] theirMac = new byte[mac.getMacLength()];
            InputStreamUtil.readFully(inputStream, theirMac);
            if (!MessageDigest.isEqual(ourMac, theirMac)) {
                LOG.info("Wrong mac. ours = " + Arrays.toString(ourMac) + " and theirs = " + Arrays.toString(theirMac) + " and length = " + length);
                throw new InvalidMacException("MAC doesn't match!");
            }
            byte[] ourDigest = digest.digest(theirMac);
            if (theirDigest != null && theirDigest.length > 0 && !MessageDigest.isEqual(ourDigest, theirDigest)) {
                LOG.info("Invalid digest with length " + theirDigest.length);
                throw new InvalidMacException("Digest doesn't match!");
            }
        }
        catch (IOException | ArithmeticException e1) {
            throw new InvalidMacException((Throwable)e1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void readFully(byte[] buffer) throws IOException {
        int read;
        int offset = 0;
        while ((read = super.read(buffer, offset, buffer.length - offset)) + offset < buffer.length) {
            offset += read;
        }
    }

    static class ContentLengthInputStream
    extends FilterInputStream {
        private long bytesRemaining;

        public ContentLengthInputStream(InputStream inputStream, long contentLength) {
            super(inputStream);
            this.bytesRemaining = contentLength;
        }

        @Override
        public int read() throws IOException {
            if (this.bytesRemaining == 0L) {
                return -1;
            }
            int result = super.read();
            --this.bytesRemaining;
            return result;
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (this.bytesRemaining == 0L) {
                return -1;
            }
            int result = super.read(buffer, offset, Math.min(length, InputStreamUtil.toIntExact(this.bytesRemaining)));
            this.bytesRemaining -= (long)result;
            return result;
        }
    }
}

