/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.backup;

import java.util.Arrays;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.kdf.HKDF;

public class BackupKey {
    private final byte[] backupKeyBytes;
    static final String BACKUP_KEY_INFO = "20231003_Signal_Backups_GenerateBackupId";
    static final String MESSAGE_KEY_INFO = "20231003_Signal_Backups_EncryptMessageBackup";
    static final int BACKUP_ID_LENGTH = 16;
    static final int BACKUP_KEY_LENGTH = 80;
    static final int MEDIA_ID_LENGTH = 15;
    static final String MEDIA_ID_INFO = "Media ID";
    static final int MEDIA_KEY_LENGTH = 80;
    static final String MEDIA_KEY_INFO = "20231003_Signal_Backups_EncryptMedia";

    public BackupKey(byte[] val) {
        if (val.length != 32) {
            throw new IllegalArgumentException("BackupKey should be 32 bytes");
        }
        this.backupKeyBytes = val;
    }

    public byte[] serialize() {
        return this.backupKeyBytes;
    }

    public KeyMaterial derviceSecrets(ServiceId.Aci aci) {
        byte[] salt = aci.toServiceIdBinary();
        byte[] backupId = HKDF.deriveSecrets((byte[])this.backupKeyBytes, (byte[])salt, (byte[])BACKUP_KEY_INFO.getBytes(), (int)16);
        byte[] extKey = HKDF.deriveSecrets((byte[])this.backupKeyBytes, (byte[])backupId, (byte[])MESSAGE_KEY_INFO.getBytes(), (int)80);
        return new KeyMaterial(backupId, Arrays.copyOfRange(extKey, 0, 32), Arrays.copyOfRange(extKey, 32, 64), Arrays.copyOfRange(extKey, 64, 80));
    }

    public KeyMaterial deriveMediaSecrets(byte[] dataHash) {
        byte[] mediaId = this.deriveMediaId(dataHash);
        byte[] extKey = HKDF.deriveSecrets((byte[])this.backupKeyBytes, (byte[])mediaId, (byte[])MEDIA_KEY_INFO.getBytes(), (int)80);
        return new KeyMaterial(mediaId, Arrays.copyOfRange(extKey, 0, 32), Arrays.copyOfRange(extKey, 32, 64), Arrays.copyOfRange(extKey, 64, 80));
    }

    byte[] deriveMediaId(byte[] dataHash) {
        return HKDF.deriveSecrets((byte[])this.backupKeyBytes, (byte[])dataHash, (byte[])MEDIA_ID_INFO.getBytes(), (int)15);
    }

    public record KeyMaterial(byte[] id, byte[] macKey, byte[] cipherKey, byte[] iv) {
    }
}

