/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.logging.Logger;

public class Util {
    private static final Logger LOG = Logger.getLogger(Util.class.getName());
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static byte[] toByteArray(UUID uuid) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return buffer.array();
    }

    public static ByteString toByteString(UUID uuid) {
        return ByteString.copyFrom((byte[])Util.toByteArray(uuid));
    }

    public static <T> T fromJson(String json, Class<T> clazz) throws JsonProcessingException {
        return (T)objectMapper.readValue(json, clazz);
    }

    public static String toJson(Object object) throws JsonProcessingException {
        return objectMapper.writeValueAsString(object);
    }

    public static byte[] getRandomLengthBytes(int maxSize) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] result = new byte[secureRandom.nextInt(maxSize) + 1];
        secureRandom.nextBytes(result);
        return result;
    }

    public static byte[][] split(byte[] input, int firstLength, int secondLength) {
        byte[][] parts = new byte[2][];
        parts[0] = new byte[firstLength];
        System.arraycopy(input, 0, parts[0], 0, firstLength);
        parts[1] = new byte[secondLength];
        System.arraycopy(input, firstLength, parts[1], 0, secondLength);
        return parts;
    }

    public static byte[] join(byte[] ... input) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (byte[] part : input) {
                baos.write(part);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] getSecretBytes(int size) {
        try {
            byte[] secret = new byte[size];
            SecureRandom.getInstance("SHA1PRNG").nextBytes(secret);
            return secret;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

