/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.securesms.crypto;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.thoughtcrime.securesms.crypto.AttachmentSecret;

public class ModernEncryptingPartOutputStream {
    private byte[] b;
    private OutputStream os;
    private static final Logger LOG = Logger.getLogger(ModernEncryptingPartOutputStream.class.getName());

    public ModernEncryptingPartOutputStream(byte[] b, OutputStream out) {
        this.b = b;
        this.os = out;
    }

    public static ModernEncryptingPartOutputStream createFor(AttachmentSecret attachmentSecret, File file, boolean inline) throws IOException {
        LOG.info("create for file = " + String.valueOf(file));
        byte[] random = new byte[32];
        new SecureRandom().nextBytes(random);
        try {
            LOG.info("mac...");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(attachmentSecret.getModernKey(), "HmacSHA256"));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] iv = new byte[16];
            byte[] key = mac.doFinal(random);
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(1, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            LOG.info("write...");
            if (inline) {
                fileOutputStream.write(random);
            }
            CipherOutputStream os = new CipherOutputStream(fileOutputStream, cipher);
            LOG.info("Now create answer");
            ModernEncryptingPartOutputStream answer = new ModernEncryptingPartOutputStream(random, os);
            LOG.info("and return answer");
            return answer;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    public byte[] getBytes() {
        return this.b;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public static long getPlaintextLength(long cipherTextLength) {
        return cipherTextLength - 32L;
    }
}

