/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.securesms.crypto;

import java.security.SecureRandom;
import java.util.logging.Logger;
import org.thoughtcrime.securesms.crypto.AttachmentSecret;

public class AttachmentSecretProvider {
    private static AttachmentSecretProvider provider;
    private AttachmentSecret attachmentSecret;
    private static final Logger LOG;

    public static synchronized AttachmentSecretProvider getInstance() {
        if (provider == null) {
            provider = new AttachmentSecretProvider();
        }
        return provider;
    }

    private AttachmentSecretProvider() {
    }

    public synchronized AttachmentSecret getOrCreateAttachmentSecret() {
        if (this.attachmentSecret != null) {
            return this.attachmentSecret;
        }
        String unencryptedSecret = null;
        this.attachmentSecret = unencryptedSecret != null ? this.getUnencryptedAttachmentSecret(unencryptedSecret) : this.createAndStoreAttachmentSecret();
        return this.attachmentSecret;
    }

    public synchronized AttachmentSecret setClassicKey(byte[] classicCipherKey, byte[] classicMacKey) {
        AttachmentSecret currentSecret = this.getOrCreateAttachmentSecret();
        currentSecret.setClassicCipherKey(classicCipherKey);
        currentSecret.setClassicMacKey(classicMacKey);
        this.storeAttachmentSecret(this.attachmentSecret);
        return this.attachmentSecret;
    }

    private AttachmentSecret getUnencryptedAttachmentSecret(String unencryptedSecret) {
        AttachmentSecret attachmentSecret = AttachmentSecret.fromString(unencryptedSecret);
        return attachmentSecret;
    }

    private AttachmentSecret createAndStoreAttachmentSecret() {
        SecureRandom random = new SecureRandom();
        byte[] secret = new byte[32];
        for (int i = 0; i < 32; ++i) {
            secret[i] = (byte)(i * 2);
        }
        AttachmentSecret attachmentSecret = new AttachmentSecret(null, null, secret);
        this.storeAttachmentSecret(attachmentSecret);
        return attachmentSecret;
    }

    private void storeAttachmentSecret(AttachmentSecret attachmentSecret) {
        LOG.info("STORE (not) attachemtn");
    }

    static {
        LOG = Logger.getLogger(AttachmentSecretProvider.class.getName());
    }
}

