/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.net;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import org.signal.protos.resumableuploads.ResumableUploads;

public final class ResumableUploadSpec {
    private final byte[] secretKey;
    private final byte[] iv;
    private final String cdnKey;
    private final Integer cdnNumber;
    private final String resumeLocation;
    private final Long expirationTimestamp;
    private final Map<String, String> headers;

    public ResumableUploadSpec(byte[] secretKey, byte[] iv, String cdnKey, int cdnNumber, String resumeLocation, long expirationTimestamp, Map<String, String> headers) {
        this.secretKey = secretKey;
        this.iv = iv;
        this.cdnKey = cdnKey;
        this.cdnNumber = cdnNumber;
        this.resumeLocation = resumeLocation;
        this.expirationTimestamp = expirationTimestamp;
        this.headers = headers;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public String getCdnKey() {
        return this.cdnKey;
    }

    public Integer getCdnNumber() {
        return this.cdnNumber;
    }

    public String getResumeLocation() {
        return this.resumeLocation;
    }

    public Long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String serialize() {
        ResumableUploads.ResumableUpload.Builder builder = ResumableUploads.ResumableUpload.newBuilder().setSecretKey(ByteString.copyFrom((byte[])this.getSecretKey())).setIv(ByteString.copyFrom((byte[])this.getIV())).setTimeout(this.getExpirationTimestamp().longValue()).setCdnNumber(this.getCdnNumber().intValue()).setCdnKey(this.getCdnKey()).setLocation(this.getResumeLocation()).setTimeout(this.getExpirationTimestamp().longValue());
        return Base64.getEncoder().encodeToString(builder.build().toByteArray());
    }

    public static ResumableUploadSpec deserialize(String serializedSpec) throws IOException {
        if (serializedSpec == null) {
            return null;
        }
        ResumableUploads.ResumableUpload resumableUpload = ResumableUploads.ResumableUpload.parseFrom((ByteString)ByteString.copyFrom((byte[])Base64.getDecoder().decode(serializedSpec)));
        return new ResumableUploadSpec(resumableUpload.getSecretKey().toByteArray(), resumableUpload.getIv().toByteArray(), resumableUpload.getCdnKey(), resumableUpload.getCdnNumber(), resumableUpload.getLocation(), resumableUpload.getTimeout(), null);
    }
}

