/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model;

import io.privacyresearch.clientdata.call.CallDbRecord;
import io.privacyresearch.clientdata.call.CallKey;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.equation.user.UserRecord;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;

public class Call {
    private CallDbRecord.Type type = CallDbRecord.Type.AUDIO_CALL;
    private ObjectProperty<CallState> stateProperty;
    private final CallKey callKey;
    private final long callId;
    private UserRecord userRecord;
    private final int otherDeviceId;
    protected Direction direction;
    private final ImageData incomingImageData;
    private final ImageData outgoingImageData;
    private final ReadOnlyBooleanWrapper webcamRunning = new ReadOnlyBooleanWrapper(false);
    private static final Logger LOG = Logger.getLogger(Call.class.getName());

    public Call(CallKey callKey, Direction direction, long callId, UserRecord recipient) {
        this(callKey, direction, callId, recipient, -1);
    }

    public Call(CallKey callKey, Direction direction, long callId, UserRecord recipient, int otherDeviceId) {
        if (direction == null) {
            throw new IllegalArgumentException("Direction should be provided");
        }
        this.callKey = callKey;
        this.direction = direction;
        this.callId = callId;
        this.userRecord = recipient;
        this.stateProperty = new SimpleObjectProperty((Object)CallState.IDLE);
        LOG.info("Created call with CALLSTATE " + String.valueOf(this.stateProperty.get()));
        this.stateProperty.addListener((obs, ov, nv) -> {
            LOG.info("CALLSTATE changed from " + String.valueOf(ov) + " to " + String.valueOf(nv));
            this.stateProperty.get();
        });
        this.otherDeviceId = otherDeviceId;
        this.incomingImageData = new ImageData(this);
        this.outgoingImageData = new ImageData(this);
        LOG.info("Created Call object, direction = " + String.valueOf((Object)direction));
    }

    public void setType(CallDbRecord.Type type) {
        this.type = type;
    }

    public CallDbRecord.Type getType() {
        return this.type;
    }

    public boolean isWebcamRunning() {
        return this.webcamRunning.get();
    }

    public void setWebcamRunning(boolean webcamRunning) {
        LOG.info("Set webcamrunning to " + webcamRunning + " for " + String.valueOf(this));
        this.webcamRunning.set(webcamRunning);
    }

    public ReadOnlyBooleanProperty webcamRunning() {
        return this.webcamRunning.getReadOnlyProperty();
    }

    public boolean isGroupCall() {
        return false;
    }

    public boolean isVideo() {
        return this.type == CallDbRecord.Type.VIDEO_CALL;
    }

    public void setRecipient(UserRecord recipient) {
        this.userRecord = recipient;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void modifyState(CallState state) {
        LOG.info("Modify callstate to " + String.valueOf((Object)state));
        this.stateProperty.set((Object)state);
    }

    public CallState getState() {
        return (CallState)((Object)this.stateProperty.get());
    }

    @Deprecated
    public ObjectProperty<CallState> state() {
        return this.stateProperty;
    }

    public CallKey getCallKey() {
        return this.callKey;
    }

    public long getCallId() {
        return this.callId;
    }

    public RecipientRecord getCallRecipient() {
        return this.userRecord.recipient();
    }

    @Deprecated
    public UserRecord getRecipient() {
        return this.userRecord;
    }

    public int getOtherDeviceId() {
        return this.otherDeviceId;
    }

    public GroupRecord getGroupRecord() {
        return null;
    }

    public ImageData getIncomingImageData() {
        return this.incomingImageData;
    }

    public ImageData getOutgoingImageData() {
        return this.outgoingImageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(int width, int height, byte[] newdata) {
        LOG.finest("Adding new image to " + String.valueOf(this.incomingImageData));
        ImageData imageData = this.incomingImageData;
        synchronized (imageData) {
            this.incomingImageData.width = width;
            this.incomingImageData.height = height;
            this.incomingImageData.data = newdata;
            ++this.incomingImageData.framecount;
            this.incomingImageData.notifyAll();
        }
        LOG.finest("Added new image to " + String.valueOf(this.incomingImageData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMyImage(int width, int height, int pixelFormat, byte[] newdata) {
        LOG.finest("Adding new image to outgoing imageData " + String.valueOf(this.outgoingImageData));
        ImageData imageData = this.outgoingImageData;
        synchronized (imageData) {
            this.outgoingImageData.width = width;
            this.outgoingImageData.height = height;
            this.outgoingImageData.pixelFormat = pixelFormat;
            this.outgoingImageData.data = newdata;
            ++this.outgoingImageData.framecount;
            this.outgoingImageData.notifyAll();
        }
        LOG.finest("Added new image to +imageData");
    }

    public static enum Direction {
        OUT,
        IN;

    }

    public static enum CallState {
        IDLE,
        DIALING,
        ANSWERING,
        REMOTE_RINGING,
        LOCAL_RINGING,
        CONNECTED,
        TERMINATED,
        RECEIVED_BUSY;

    }

    public class ImageData {
        private byte[] data;
        private int width;
        private int height;
        private int pixelFormat;
        private long framecount;

        public ImageData(Call this$0) {
        }

        public byte[] getData() {
            return this.data;
        }

        public int getWidth() {
            return this.width;
        }

        public int getPixelFormat() {
            return this.pixelFormat;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

