/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.message;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.message.InsertMessageRequest;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.user.UserRecord;
import org.signal.libsignal.protocol.ServiceId;

public class MessageService {
    private final EquationManager equation;
    private final MessageData messageData;

    public MessageService(EquationManager equation, MessageData messageData) {
        this.equation = equation;
        this.messageData = messageData;
    }

    public MessageKey insertMessage(InsertMessageRequest messageRequest) {
        if (messageRequest.getReceiverKey() == null) {
            throw new IllegalArgumentException("Can't insert a message without a receiverKey");
        }
        if (messageRequest.getSenderKey() == null) {
            throw new IllegalArgumentException("Can't insert a message without a senderKey");
        }
        return this.messageData.insertMessage(messageRequest);
    }

    public MessageDbRecord findByMessageKey(MessageKey key) {
        return (MessageDbRecord)this.messageData.findByKey((EntityKey)key);
    }

    public MessageDbRecord findByAuthorAndTimestamp(String serviceId, long ts) {
        try {
            ServiceId aci = ServiceId.parseFromString((String)serviceId);
            UserRecord user = this.equation.getUserService().getUserByServiceId(aci).orElseThrow();
            MessageDbRecord messageDbRecord = this.messageData.getByFromRecipientKeyAndDateSent(user.recipient().key(), ts);
            return messageDbRecord;
        }
        catch (ServiceId.InvalidServiceIdException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public boolean ensureThreadRoot(MessageKey key) {
        MessageDbRecord record = (MessageDbRecord)this.messageData.findByKey((EntityKey)key);
        MessageKey exists = record.threadRootKey();
        if (exists != null) {
            if (exists.equals((Object)key)) {
                return true;
            }
            throw new IllegalArgumentException("Message already has a threadrootkey (" + String.valueOf(exists) + "), but it should be " + String.valueOf(key));
        }
        this.messageData.updateThreadRoot(key, key);
        return false;
    }
}

