/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.export;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.attachment.AttachmentRecord;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.equation.AttachmentUtil;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.attachment.AttachmentService;
import io.privacyresearch.equation.attachment.BackfillRequestUpdate;
import io.privacyresearch.equation.export.ExportMessage;
import io.privacyresearch.equation.export.ExportOptions;
import io.privacyresearch.equation.model.FullQuoteRecord;
import io.privacyresearch.equation.model.MessageRecord;
import io.privacyresearch.equation.model.ReactionRecord;
import io.privacyresearch.equation.user.UserRecord;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;

public class ExportService {
    private static final String HTML_START = "<html>\n<head>\n    <link href=\"https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap\" rel=\"stylesheet\">\n    <style>\n    body {\n      font-family: \"Inter\", system-ui, -apple-system, \"Segoe UI\", Roboto, Arial, sans-serif;\n      background: #f7f8fb;\n      margin: 0;\n      padding: 20px;\n    }\n\n    .dayseparator {\n      text-align: center;\n      color: #6b7280;\n      font-weight: 600;\n      margin: 20px 0;\n      font-size: 0.9rem;\n    }\n\n    .message {\n      display: flex;\n      flex-direction: column;\n      max-width: 70%;\n      margin-bottom: 12px;\n      position: relative;\n      clear: both;\n    }\n\n    /* Outgoing (mine) messages aligned right */\n    .message.mine {\n      margin-left: auto;\n      align-items: flex-end;\n    }\n\n    /* Incoming (other) messages aligned left */\n    .message.other {\n      margin-right: auto;\n      align-items: flex-start;\n    }\n\n    .date {\n      font-size: 0.75rem;\n      color: #9ca3af;\n      margin-bottom: 2px;\n    }\n\n    .sender {\n      font-size: 0.8rem;\n      font-weight: 600;\n      margin-bottom: 2px;\n      color: #2563eb;\n    }\n\n    .message.mine .sender {\n      color: #111827;\n    }\n\n    .text {\n      padding: 10px 12px;\n      border-radius: 14px;\n      line-height: 1.4;\n      font-size: 0.95rem;\n      word-break: break-word;\n      box-shadow: 0 1px 3px rgba(0,0,0,0.08);\n    }\n\n    /* Bubble colors */\n    .message.other .text {\n      background: #ffffff;\n      border: 1px solid #e5e7eb;\n    }\n\n    .message.mine .text {\n      background: #dbeafe;\n      border: 1px solid #bfdbfe;\n    }\n\n    /* Quote/reply styling */\n    .quote {\n      background: #f3f4f6;\n      border-left: 3px solid #9ca3af;\n      border-radius: 8px;\n      padding: 6px 8px;\n      margin-bottom: 6px;\n      font-size: 0.85rem;\n      color: #374151;\n    }\n\n    .reply {\n      margin-top: 4px;\n    }\n\n    /* Attachments */\n    .image {\n      display: block;\n      max-width: 280px;\n      width: 100%;\n      height: auto;\n      border-radius: 10px;\n      margin-top: 8px;\n      box-shadow: 0 1px 4px rgba(0,0,0,0.08);\n    }\n\n    /* Reactions as badges at bottom of bubble */\n    .reactions {\n      display: flex;\n      gap: 6px;\n      margin-top: 4px;\n      font-size: 0.8rem;\n    }\n\n    .reaction {\n      background: #f3f4f6;\n      border-radius: 12px;\n      padding: 2px 8px;\n      border: 1px solid #e5e7eb;\n    }\n\n    .message.mine + .reactions {\n      justify-content: flex-end;\n    }\n    </style>\n</head>\n<body>\n";
    private static final String HTML_END = "</body>\n</html>\n";
    private static final String HTML_TEMPLATE_DATE_SEP = "<div class=\"dayseparator\">%s</div>";
    private static final String HTML_PREV_PAGE = "<a href=\"%s\">previous page</a>";
    private static final String HTML_NEXT_PAGE = "<a href=\"%s\">next page</a>";
    private static final String HTML_TEMPLATE = "<div class=\"message %s\">\n    <span class=\"date\">%s</span>\n    <span class=\"sender\">%s</span>\n    <div class=\"text\">%s</div>\n</div>\n";
    private static final String HTML_TEMPLATE_QUOTE = "<div class=\"message %s\">\n    <span class=\"date\">%s</span>\n    <span class=\"sender\">%s</span>\n    <div class=\"text\">\n        <div class=\"quote\">%s</div>\n        <div class=\"reply\">%s</div>\n    </div>\n</div>\n";
    private static final Logger LOG = Logger.getLogger(ExportService.class.getName());
    private final EquationManager equation;
    private AttachmentService attachmentService;
    private UserRecord me = null;
    DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy").withZone(ZoneId.systemDefault());
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss").withZone(ZoneId.systemDefault());
    Function<UUID, String> uuidMapper;
    Function<MessageKey, ExportMessage.Quote> quoteRetriever;
    Function<MessageKey, List<ExportMessage.Reaction>> reactionRetriever;
    Map<AttachmentKey, Path> attachmentKeyDestinationMap = new HashMap<AttachmentKey, Path>();
    Map<AttachmentKey, AttachmentRecord> attachmentKeyRecordMap = new HashMap<AttachmentKey, AttachmentRecord>();
    List<MessageKey> messageBackfillList = new LinkedList<MessageKey>();
    int bcount = 0;
    boolean allowbackfill = true;
    private static final Map<String, String> EXTENSIONS = Map.of("image/jpeg", ".jpg", "image/png", ".png", "image/gif", ".gif", "application/pdf", ".pdf");

    public ExportService(EquationManager equation) {
        this.equation = equation;
        if (equation != null) {
            this.me = equation.getAccount().getUser();
            this.quoteRetriever = key -> {
                FullQuoteRecord fqr = equation.getQuoteByMessageKey((MessageKey)key);
                if (fqr != null) {
                    MessageDbRecord mdbrecord = (MessageDbRecord)equation.getSqliteStorageBean().getMessageData().findByKey((EntityKey)fqr.quotedMessageKey());
                    if (mdbrecord == null) {
                        LOG.info("COULD NOT FIND QUOTE, orig key = " + String.valueOf(key) + " and fqr = " + String.valueOf(fqr));
                        return null;
                    }
                    return new ExportMessage.Quote(mdbrecord.dateSent(), fqr.body());
                }
                return null;
            };
            this.reactionRetriever = key -> {
                List<ReactionRecord> rrs = equation.getReactionsByMessageKey((MessageKey)key);
                if (rrs == null || rrs.isEmpty()) {
                    return null;
                }
                ArrayList<ExportMessage.Reaction> reactions = new ArrayList<ExportMessage.Reaction>();
                for (ReactionRecord rr : rrs) {
                    UserRecord author = equation.getUserByRecipientKey(rr.authorRecipientKey());
                    reactions.add(new ExportMessage.Reaction(rr.emoji(), author.name()));
                }
                return reactions;
            };
            this.uuidMapper = uuid -> {
                try {
                    Optional<UserRecord> userOpt = equation.getUserService().getUserByServiceId(ServiceId.parseFromString((String)uuid.toString()));
                    if (userOpt.isPresent()) {
                        return userOpt.get().name();
                    }
                }
                catch (ServiceId.InvalidServiceIdException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
                return "unknown";
            };
        }
        this.attachmentService = equation.getAttachmentService();
    }

    public ExportService(Function<UUID, String> uuidMapper) {
        this.equation = null;
        this.uuidMapper = uuidMapper;
    }

    public void setQuoteRetriever(Function<MessageKey, ExportMessage.Quote> quoteRetriever) {
        this.quoteRetriever = quoteRetriever;
    }

    public void setReactionRetriever(Function<MessageKey, List<ExportMessage.Reaction>> reactionRetriever) {
        this.reactionRetriever = reactionRetriever;
    }

    public ExportMessage createExportMessage(MessageRecord messageRecord) {
        return this.createExportMessage(messageRecord, null);
    }

    public ExportMessage createExportMessage(MessageRecord messageRecord, Path mediaPath) {
        List<ExportMessage.Attachment> storedMedia;
        List<ExportMessage.Reaction> reactions;
        ExportMessage.Quote quote;
        ExportMessage answer = new ExportMessage(messageRecord);
        answer.setBody(this.getMessageBody(messageRecord));
        if (this.quoteRetriever != null && (quote = this.quoteRetriever.apply(messageRecord.key())) != null) {
            answer.setQuote(quote);
        }
        if (this.reactionRetriever != null && (reactions = this.reactionRetriever.apply(messageRecord.key())) != null) {
            answer.setReactions(reactions);
        }
        if (mediaPath != null && (storedMedia = this.storeAttachments(messageRecord, mediaPath)) != null && !storedMedia.isEmpty()) {
            answer.setAttachments(storedMedia);
        }
        return answer;
    }

    public CompletableFuture<Status> export(RecipientKey key, ExportOptions options, File destinationFile) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                List<MessageRecord> messages = this.equation.getMessagesForRecipientKey(key);
                ExportOptions.ExportType exportType = options.getExportType();
                LOG.info("ExportType = " + String.valueOf((Object)exportType));
                if (exportType.equals((Object)ExportOptions.ExportType.HTML)) {
                    this.htmlExport(messages, destinationFile.toPath(), options);
                } else if (exportType.equals((Object)ExportOptions.ExportType.JSON)) {
                    this.jsonExport(messages, destinationFile.toPath(), options);
                } else {
                    this.textExport(messages, destinationFile.toPath(), options);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOG.severe("Export failed because of " + String.valueOf(ex));
                return Status.FAILED;
            }
            LOG.info("Export done");
            return Status.DONE;
        });
    }

    void textExport(List<MessageRecord> messages, Path destination, ExportOptions options) throws IOException {
        Files.writeString(destination, (CharSequence)"MESSAGES\n", new OpenOption[0]);
        LOG.info("got " + messages.size() + " messages.");
        long day = 0L;
        try (BufferedWriter writer = Files.newBufferedWriter(destination, StandardOpenOption.APPEND);){
            for (MessageRecord message : messages) {
                long ts = message.dateSent();
                Instant timeInstant = Instant.ofEpochMilli(ts);
                long newday = this.toEpochDay(ts);
                if (newday > day) {
                    writer.newLine();
                    writer.write("=== " + this.dateFormatter.format(Instant.ofEpochMilli(ts)) + " ===");
                    writer.newLine();
                    day = newday;
                }
                String date = this.formatter.format(timeInstant);
                writer.write(this.formatMessageRecord(message));
                writer.newLine();
            }
        }
        LOG.info("Wrote them");
    }

    void jsonExport(List<MessageRecord> messages, Path destinationDir, ExportOptions options) throws IOException {
        Path destination = destinationDir.resolve("messages.json");
        Path mediaDir = destinationDir.resolve("attachments");
        LOG.info("Json export to " + String.valueOf(destination) + " starts");
        Files.createDirectories(destinationDir, new FileAttribute[0]);
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter();
        mapper.setDefaultPrettyPrinter((PrettyPrinter)pp);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        try {
            BufferedWriter bw = Files.newBufferedWriter(destination, new OpenOption[0]);
            try (SequenceWriter seqWriter = writer.writeValues((Writer)bw);){
                seqWriter.init(true);
                for (MessageRecord messageRecord : messages) {
                    ExportMessage exportMessage = this.createExportMessage(messageRecord, mediaDir);
                    seqWriter.write((Object)exportMessage);
                }
            }
        }
        catch (IOException e) {
            LOG.severe("Exception writing json content: " + String.valueOf(e));
            e.printStackTrace();
        }
        LOG.info("Json export to " + String.valueOf(destination) + " done");
    }

    void htmlExport(List<MessageRecord> messages, Path destinationDir, ExportOptions options) throws IOException {
        LOG.info("HTML export to " + String.valueOf(destinationDir) + " starts");
        Path mediaPath = destinationDir.resolve("attachments");
        Files.createDirectories(mediaPath, new FileAttribute[0]);
        int NUM_PER_PAGE = 100;
        int numMessages = messages.size();
        String filename = "0.html";
        Path destination = destinationDir.resolve(filename);
        Files.createDirectories(mediaPath, new FileAttribute[0]);
        if (numMessages < 101) {
            this.partialHtmlExport(messages, destination, mediaPath, -1, -1);
        } else {
            int pageCount = 0;
            int count = 0;
            while (count < numMessages) {
                destination = destinationDir.resolve(pageCount + ".html");
                List<MessageRecord> subList = messages.subList(count, Math.min(count + 100, numMessages));
                boolean hasNextPage = count + 100 < numMessages;
                this.partialHtmlExport(subList, destination, mediaPath, pageCount - 1, hasNextPage ? pageCount + 1 : -1);
                count += 100;
                ++pageCount;
            }
        }
    }

    void partialHtmlExport(List<MessageRecord> messages, Path destination, Path mediaPath, int prev, int next) throws IOException {
        Files.writeString(destination, (CharSequence)HTML_START, new OpenOption[0]);
        LOG.info("got " + messages.size() + " messages.");
        long day = 0L;
        try (BufferedWriter writer = Files.newBufferedWriter(destination, StandardOpenOption.APPEND);){
            Object pp;
            if (prev > -1) {
                pp = prev + ".html";
                writer.write(String.format(HTML_PREV_PAGE, pp));
                writer.newLine();
            }
            for (MessageRecord message : messages) {
                ExportMessage exportMessage = this.createExportMessage(message, mediaPath);
                long ts = message.dateSent();
                Instant timeInstant = Instant.ofEpochMilli(ts);
                long newday = this.toEpochDay(ts);
                if (newday > day) {
                    writer.newLine();
                    writer.write(String.format(HTML_TEMPLATE_DATE_SEP, this.dateFormatter.format(Instant.ofEpochMilli(ts))));
                    writer.newLine();
                    day = newday;
                }
                String date = this.formatter.format(timeInstant);
                writer.write(this.formatExportedMessageRecordToHtml(message, exportMessage, mediaPath));
                writer.newLine();
            }
            if (next > -1) {
                pp = next + ".html";
                writer.write(String.format(HTML_NEXT_PAGE, pp));
                writer.newLine();
            }
            writer.write(HTML_END);
        }
        LOG.info("Wrote them");
    }

    long toEpochDay(long t) {
        Instant timeInstant = Instant.ofEpochMilli(t);
        ZonedDateTime zonedDateTime = timeInstant.atZone(ZoneOffset.systemDefault());
        return zonedDateTime.toLocalDate().toEpochDay();
    }

    String formatMessageRecord(MessageRecord msg) {
        long ts = msg.dateSent();
        Instant timeInstant = Instant.ofEpochMilli(ts);
        String date = this.formatter.format(timeInstant);
        String answer = "[" + date + "] " + msg.sender().name() + ": " + msg.body();
        return answer;
    }

    String formatExportedMessageRecordToHtml(MessageRecord messageRecord, ExportMessage msg, Path mediaPath) {
        long ts = msg.timestamp;
        Instant timeInstant = Instant.ofEpochMilli(ts);
        String date = this.formatter.format(timeInstant);
        String attText = this.addAttachments(msg, mediaPath);
        String reactions = this.formatReactions(msg);
        String body = msg.body + attText;
        String messageClass = this.isMe(messageRecord) ? "mine" : "other";
        return (msg.quote != null ? String.format(HTML_TEMPLATE_QUOTE, messageClass, date, msg.authorName, msg.quote.quote, body) : String.format(HTML_TEMPLATE, messageClass, date, msg.authorName, body)) + reactions;
    }

    String formatReactions(ExportMessage msg) {
        Object answer = "";
        if (msg.reactions == null || msg.reactions.isEmpty()) {
            return answer;
        }
        answer = "<div class=\"reactions\">&nbsp;";
        for (ExportMessage.Reaction reaction : msg.reactions) {
            answer = (String)answer + "<div class=\"reaction\">" + reaction.emoji + " (" + reaction.authorName + ")</div>";
        }
        answer = (String)answer + "</div>";
        return answer;
    }

    String addAttachments(ExportMessage em, Path mediaPath) {
        Object answer = "";
        if (em.attachments == null) {
            return answer;
        }
        for (ExportMessage.Attachment p : em.attachments) {
            String img = p.path;
            if (this.isImage(p.contentType)) {
                answer = (String)answer + "<a href=\"" + img + "\"><img src=\"" + img + "\" class=\"image\"></a>";
                continue;
            }
            answer = (String)answer + "<a href=\"" + img + "\">" + img + "</a>";
        }
        return answer;
    }

    List<ExportMessage.Attachment> storeAttachments(MessageRecord msg, Path mediaPath) {
        ArrayList<ExportMessage.Attachment> imgList = new ArrayList<ExportMessage.Attachment>();
        if (this.equation != null) {
            List<AttachmentRecord> atts = this.equation.getAttachmentsByMessageKey(msg.key());
            LOG.finer("Need to download attachments for msg = " + String.valueOf(msg) + " and atts = " + String.valueOf(atts));
            for (AttachmentRecord att : atts) {
                try {
                    Object fileName = att.fileName();
                    if (fileName == null) {
                        String extension = this.getExtensionByContentType(att.contentType());
                        fileName = att.key().serialize() + extension;
                    }
                    Path p = mediaPath.resolve((String)fileName);
                    for (int suf = 1; Files.exists(p, new LinkOption[0]) && suf < 100; ++suf) {
                        LOG.finer("file named " + String.valueOf(p) + " already exists");
                        if (suf == 99) {
                            suf = 100 + new Random().nextInt(0x20000000);
                        }
                        p = mediaPath.resolve((String)fileName + "_" + suf);
                    }
                    LOG.finer("Storing attachment with name " + String.valueOf(p));
                    int segs = p.getNameCount();
                    ExportMessage.Attachment attmsg = new ExportMessage.Attachment(p.subpath(segs - 2, segs).toString(), att.contentType(), att.uploadTimestamp());
                    imgList.add(attmsg);
                    if (this.downloadFromMediaService(att, p)) {
                        LOG.finer("Download to " + String.valueOf(p) + " is ok");
                        continue;
                    }
                    this.backfillRequest(msg, att, p);
                    LOG.finer("No inputStream for attachment " + String.valueOf(att) + " of message " + msg.dateSent());
                }
                catch (IOException ex) {
                    LOG.severe("Could not download attachment!");
                    ex.printStackTrace();
                }
            }
        }
        return imgList;
    }

    boolean downloadFromMediaService(AttachmentRecord att, Path p) throws IOException {
        InputStream is = AttachmentUtil.getInputStream(att);
        if (is != null) {
            LOG.finer("Store attachment ");
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            Files.copy(is, p, StandardCopyOption.REPLACE_EXISTING);
            FileTime createdTimestamp = FileTime.fromMillis(att.uploadTimestamp());
            Files.setAttribute(p, "basic:lastModifiedTime", createdTimestamp, new LinkOption[0]);
            return true;
        }
        return false;
    }

    void backfillRequest(MessageRecord msg, AttachmentRecord att, Path destination) {
        ++this.bcount;
        if (this.bcount > 100) {
            this.allowbackfill = false;
        }
        if (!this.allowbackfill) {
            LOG.info("We don't do more than 100 backfills atm");
            return;
        }
        LOG.finer("Try backfill for " + String.valueOf(msg) + ", count = " + this.bcount);
        this.attachmentKeyDestinationMap.put(att.key(), destination);
        this.attachmentKeyRecordMap.put(att.key(), att);
        if (this.messageBackfillList.contains(msg.key())) {
            LOG.info("We already have a backfill request for attachments of this message");
            return;
        }
        LOG.finer("ATTKEYMAP = " + String.valueOf(this.attachmentKeyRecordMap));
        Consumer<BackfillRequestUpdate> consumer = bpr -> {
            LOG.info("Info available for backfillrequest " + String.valueOf(bpr) + " with key = " + String.valueOf(bpr.getAttachmentKey()) + " and oldkey = " + String.valueOf(bpr.getOldKey()));
            if (BackfillRequestUpdate.Status.DOWNLOADED == bpr.getStatus()) {
                try {
                    LOG.finer("Download should be ready, now copy");
                    AttachmentKey oldAttachmentKey = bpr.getOldKey();
                    AttachmentRecord attachmentRecord = this.attachmentService.getAttachmentRecord(bpr.getAttachmentKey());
                    AttachmentRecord attRecord = this.attachmentKeyRecordMap.get(oldAttachmentKey);
                    Path p = this.attachmentKeyDestinationMap.get(oldAttachmentKey);
                    LOG.finer("File is copied to " + String.valueOf(p));
                    this.downloadFromMediaService(attRecord, p);
                }
                catch (Throwable t) {
                    LOG.info("Unexpected issue");
                    t.printStackTrace();
                }
            }
        };
        this.equation.requestBackfill(msg.key(), consumer);
    }

    String getMessageBody(MessageRecord messageRecord) {
        List<BodyRange> bodyRanges = messageRecord.bodyRanges();
        if (bodyRanges == null) {
            return messageRecord.body();
        }
        bodyRanges.sort(Comparator.comparingInt(BodyRange::start).reversed());
        Object body = messageRecord.body();
        for (BodyRange br : bodyRanges) {
            if (!br.isMention()) continue;
            String user = "unknown";
            UUID uuid = UUID.fromString(br.mentionAci());
            user = this.uuidMapper.apply(uuid);
            body = ((String)body).substring(0, br.start()) + user + ((String)body).substring(br.start() + 1);
        }
        return body;
    }

    private String getExtensionByContentType(String contentType) {
        return EXTENSIONS.getOrDefault(contentType, "");
    }

    private boolean isImage(String contentType) {
        LOG.info("Need to know if this is an image, ct = " + contentType);
        return contentType.toLowerCase().startsWith("image");
    }

    private boolean isMe(MessageRecord msg) {
        return this.me == null ? false : msg.sender().aci().equals((Object)this.me.aci());
    }

    public static enum Status {
        DONE,
        FAILED;

    }
}

