/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.attachment;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.attachment.AttachmentData;
import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.attachment.AttachmentRecord;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.equation.AttachmentUtil;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.attachment.AttachmentPointerUtil;
import io.privacyresearch.equation.attachment.BackfillRequestUpdate;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentPointer;
import io.privacyresearch.equation.model.Attachment;
import io.privacyresearch.equation.model.MessageRecord;
import io.privacyresearch.equation.user.UserRecord;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;
import org.whispersystems.signalservice.api.InvalidMessageStructureException;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class AttachmentService {
    private static final Logger LOG = Logger.getLogger(AttachmentService.class.getName());
    private final AttachmentData attachmentData;
    private final EquationManager equation;
    private Map<MessageKey, Consumer<BackfillRequestUpdate>> map = new HashMap<MessageKey, Consumer<BackfillRequestUpdate>>();

    public AttachmentService(EquationManager equation, AttachmentData attachmentData) {
        this.attachmentData = attachmentData;
        this.equation = equation;
    }

    public AttachmentRecord getAttachmentRecord(AttachmentKey key) {
        return (AttachmentRecord)this.attachmentData.findByKey((EntityKey)key);
    }

    public void startDownloading() throws SQLException {
        LOG.info("Retrieve missing attachment data");
        List<AttachmentRecord> records = this.getNonStoredAttachments();
        ArrayList<AttachmentRecord> reversed = new ArrayList<AttachmentRecord>(records);
        Collections.reverse(reversed);
        LOG.info("We need data for " + records.size() + " attachments");
        for (AttachmentRecord record : reversed) {
            try {
                AttachmentUtil.storeAttachmentFromRecord(record, null);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    public void processBackfillResponse(SignalServiceProtos.SyncMessage.AttachmentBackfillResponse response) {
        try {
            SignalServiceProtos.AddressableMessage targetMessage = response.getTargetMessage();
            long sent = targetMessage.getSentTimestamp();
            LOG.info("process message with date " + sent);
            String authorServiceId = targetMessage.getAuthorServiceId();
            Optional<UserRecord> userByServiceId = this.equation.getUserService().getUserByServiceId(ServiceId.parseFromString((String)authorServiceId));
            if (userByServiceId.isEmpty()) {
                LOG.severe("Can not find user with serviceId " + authorServiceId);
                throw new IllegalArgumentException("No user with serviceId " + authorServiceId);
            }
            RecipientKey recipientKey = userByServiceId.get().recipient().key();
            MessageDbRecord message = this.equation.getSqliteStorageBean().getMessageData().getByFromRecipientKeyAndDateSent(recipientKey, sent);
            MessageKey messageKey = message.key();
            Consumer<BackfillRequestUpdate> consumer = this.map.get(messageKey);
            LOG.info("Notify consumer " + String.valueOf(consumer) + " about response");
            if (consumer != null) {
                consumer.accept(new BackfillRequestUpdate(messageKey, null, null, BackfillRequestUpdate.Status.GOT_RESPONSE));
            }
            List attachmentsList = response.getAttachments().getAttachmentsList();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Process list " + String.valueOf(attachmentsList));
            }
            for (SignalServiceProtos.SyncMessage.AttachmentBackfillResponse.AttachmentData attachment : attachmentsList) {
                AttachmentKey newKey;
                if (attachment.hasStatus() && attachment.getStatus().equals((Object)SignalServiceProtos.SyncMessage.AttachmentBackfillResponse.AttachmentData.Status.PENDING)) {
                    LOG.info("Status pending, ignore for now");
                    continue;
                }
                SignalServiceProtos.AttachmentPointer att = attachment.getAttachment();
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Process pointer " + String.valueOf(att));
                }
                List recs = this.attachmentData.findByMessageKey(message.key());
                AttachmentKey oldKey = null;
                Optional<AttachmentRecord> exist = recs.stream().filter(rec -> Arrays.equals(rec.remoteKey(), att.getKey().toByteArray())).findFirst();
                if (exist.isPresent()) {
                    oldKey = exist.get().key();
                    LOG.info("We have an existing attachmentrecord (with key " + String.valueOf(oldKey) + ") that we will delete later");
                }
                if ((newKey = this.handleAttachmentPointer(att, message.key())) != null) {
                    AttachmentRecord record = (AttachmentRecord)this.attachmentData.findByKey((EntityKey)newKey);
                    CompletableFuture downloading = null;
                    if (consumer != null) {
                        consumer.accept(new BackfillRequestUpdate(messageKey, oldKey, newKey, BackfillRequestUpdate.Status.DOWNLOADING));
                    }
                    try {
                        downloading = AttachmentUtil.storeAttachmentFromRecord(record, null);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, "Error downloading attachment", ex);
                    }
                    LOG.info("We stored a new attachment and are downloading data");
                    if (exist.isPresent()) {
                        LOG.info("Deleting old attatchment");
                        this.attachmentData.delete((EntityKey)exist.get().key());
                        LOG.info("Deleted old attatchment");
                    }
                    MessageDbRecord dbRecord = (MessageDbRecord)this.equation.getSqliteStorageBean().getMessageData().findByKey((EntityKey)message.key());
                    MessageRecord messageRecord = this.equation.getMessageRecordFromDb(dbRecord);
                    AttachmentKey previousKey = oldKey;
                    downloading.thenAccept(e -> {
                        LOG.info("Download is available, notify Wave");
                        this.equation.getWaveClient().gotUpdatedMessageRecord(messageRecord);
                        if (consumer != null) {
                            consumer.accept(new BackfillRequestUpdate(messageKey, previousKey, newKey, BackfillRequestUpdate.Status.DOWNLOADED));
                        }
                    });
                }
                LOG.info("Processed");
            }
        }
        catch (ServiceId.InvalidServiceIdException ex) {
            LOG.log(Level.SEVERE, "CRAP!", ex);
        }
    }

    public AttachmentKey handleAttachmentPointer(SignalServiceProtos.AttachmentPointer att, MessageKey messageKey) {
        try {
            SignalServiceAttachmentPointer ssap = AttachmentPointerUtil.createSignalAttachmentPointer(att);
            SignalServiceProtos.AttachmentPointer ap = ssap.toAttachmentPointerBuilder().build();
            Path destinationDir = this.equation.SIGNAL_FX_ATTACHMENT_DIR.resolve("imported");
            Attachment attachment = AttachmentUtil.createAttachmentFromPointer(ssap, destinationDir);
            LOG.info("location of new attachment: " + String.valueOf(attachment.getPath()));
            AttachmentKey attachmentKey = this.equation.getSqliteStorageBean().getAttachmentData().addAttachment(messageKey, ap, attachment.getPath().toString(), -1);
            LOG.info("Handled pointer for new key " + String.valueOf(attachmentKey));
            return attachmentKey;
        }
        catch (InvalidMessageStructureException ex) {
            LOG.log(Level.SEVERE, "invalid message", ex);
            return null;
        }
    }

    public Attachment.LocalDownloadStatus getAttachmentStatus(AttachmentKey key) {
        AttachmentRecord record = (AttachmentRecord)this.attachmentData.findByKey((EntityKey)key);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Att status asked for " + String.valueOf(key) + ", record = " + String.valueOf(record));
        }
        if (record == null) {
            return Attachment.LocalDownloadStatus.KEY_NOT_FOUND;
        }
        String location = record.location();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Location = " + location);
        }
        if (location == null) {
            return Attachment.LocalDownloadStatus.NO_FILE;
        }
        if (AttachmentService.readyToUse(location)) {
            return Attachment.LocalDownloadStatus.FILE_READY;
        }
        if (this.downloading(location)) {
            return Attachment.LocalDownloadStatus.FILE_DOWNLOADING;
        }
        LOG.severe("No status known for " + String.valueOf(record) + ", return NO_FILE");
        return Attachment.LocalDownloadStatus.NO_FILE;
    }

    private boolean fileExists(String loc) {
        Path path = Paths.get(loc, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            return true;
        }
        Path encPat = Paths.get(loc + ".enc", new String[0]);
        if (Files.exists(encPat, new LinkOption[0]) && Files.isRegularFile(encPat, new LinkOption[0])) {
            return true;
        }
        Path encnotPat = Paths.get(loc + ".enc.not", new String[0]);
        return Files.exists(encnotPat, new LinkOption[0]) && Files.isRegularFile(encnotPat, new LinkOption[0]);
    }

    protected static boolean readyToUse(String loc) {
        Path regPat = Paths.get(loc, new String[0]);
        Path encPat = Paths.get(loc + ".enc", new String[0]);
        return Files.exists(encPat, new LinkOption[0]) && Files.isRegularFile(encPat, new LinkOption[0]) || Files.exists(regPat, new LinkOption[0]) && Files.isRegularFile(regPat, new LinkOption[0]);
    }

    private boolean downloading(String loc) {
        Path encPat = Paths.get(loc + ".enc.dl", new String[0]);
        return Files.exists(encPat, new LinkOption[0]) && Files.isRegularFile(encPat, new LinkOption[0]);
    }

    private List<AttachmentRecord> getNonStoredAttachments() throws SQLException {
        return this.attachmentData.findAll().stream().filter(ar -> ar.cdnNumber() > 0).filter(ar -> !this.fileExists(ar.location())).toList();
    }

    public void registerBackfillRequest(MessageKey messageKey, Consumer<BackfillRequestUpdate> consumer) {
        this.map.put(messageKey, consumer);
    }
}

