/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.message.InsertMessageRequest;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.ReceiptType;
import io.privacyresearch.clientdata.poll.PollData;
import io.privacyresearch.clientdata.poll.PollDbRecord;
import io.privacyresearch.clientdata.poll.PollVoteData;
import io.privacyresearch.clientdata.poll.PollVoteDbRecord;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.clientdata.util.UUIDUtil;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.message.MessageService;
import io.privacyresearch.equation.model.MessageRecord;
import io.privacyresearch.equation.model.PollRecord;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.user.UserService;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class PollService {
    private final EquationManager equation;
    private final SqliteStorageBean db;
    private final PollData pollData;
    private final PollVoteData pollVoteData;
    private final UserService userService;
    private final MessageService messageService;
    static final Logger LOG = Logger.getLogger(PollService.class.getName());

    public PollService(EquationManager equation, SqliteStorageBean db) {
        this.equation = equation;
        this.db = db;
        this.pollData = db.getPollData();
        this.pollVoteData = db.getPollVoteData();
        this.userService = equation.getUserService();
        this.messageService = equation.getMessageService();
    }

    public PollDbRecord processIncomingPoll(UserKey senderKey, RecipientRecord receiver, SignalServiceProtos.DataMessage.PollCreate proto, long timestamp) {
        UserRecord sender = this.userService.getUserByUserKey(senderKey);
        MessageKey messageKey = this.createMessageKeyForPoll(sender, receiver, timestamp);
        PollDbRecord record = new PollDbRecord(null, senderKey, receiver.key(), messageKey, proto.getQuestion(), (List)proto.getOptionsList(), proto.hasAllowMultiple(), timestamp);
        PollDbRecord answer = this.pollData.createPoll(record);
        MessageRecord.Builder messageBuilder = new MessageRecord.Builder().messageKey(messageKey).dateSent(timestamp).receiverKey(receiver.key()).sender(sender).receiptType(ReceiptType.UNKNOWN);
        messageBuilder.pollRecord(this.createPollRecordFromDb(answer));
        MessageRecord messageRecord = messageBuilder.build();
        if (this.equation.getWaveClient() != null) {
            this.equation.getWaveClient().gotMessageRecord(messageRecord);
        }
        return answer;
    }

    public PollVoteDbRecord processIncomingVote(UserKey voterKey, GroupRecord groupRecord, SignalServiceProtos.DataMessage.PollVote proto) {
        byte[] aciBytes = proto.getTargetAuthorAciBinary().toByteArray();
        UUID uuid = UUIDUtil.bytesToUuid((byte[])aciBytes);
        UserRecord authorRecord = this.userService.getUserByUUID(uuid);
        UserRecord userRecord = this.userService.getUserByUserKey(voterKey);
        List candidates = this.pollData.findByTarget(groupRecord.recipient().key());
        Optional<PollDbRecord> found = candidates.stream().filter(pdb -> pdb.timestamp() == proto.getTargetSentTimestamp()).findFirst();
        LOG.info("Processing vote, uuid = " + String.valueOf(uuid) + ", found ? " + String.valueOf(found));
        if (found.isEmpty()) {
            throw new IllegalArgumentException("Did not find a matching poll");
        }
        PollDbRecord poll = found.get();
        PollVoteDbRecord record = new PollVoteDbRecord(null, poll.key(), userRecord.key(), proto.getOptionIndexesList(), proto.getVoteCount());
        PollVoteDbRecord answer = this.pollVoteData.vote(record);
        MessageKey messageKey = poll.messageKey();
        MessageDbRecord mdbRecord = this.messageService.findByMessageKey(messageKey);
        MessageRecord messageRecord = this.equation.getMessageRecordFromDb(mdbRecord);
        if (this.equation.getWaveClient() != null) {
            this.equation.getWaveClient().gotMessageRecord(messageRecord);
        }
        return answer;
    }

    public PollRecord createPoll(String question, List<String> options, boolean multiple) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PollRecord getPollRecordByMessageKey(MessageKey messageKey) {
        try {
            List allPolls = this.pollData.findAll();
            Optional<PollDbRecord> optPoll = allPolls.stream().filter(poll -> poll.messageKey().equals((Object)messageKey)).findFirst();
            if (optPoll.isPresent()) {
                return this.createPollRecordFromDb(optPoll.get());
            }
            return null;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    PollRecord createPollRecordFromDb(PollDbRecord pdr) {
        PollRecord.Type type = pdr.allowMultipleVotes() ? PollRecord.Type.MULTIPLE_CHOICE : PollRecord.Type.SINGLE_CHOICE;
        HashMap<String, Set<UserRecord>> votesMap = new HashMap<String, Set<UserRecord>>();
        pdr.options().stream().forEach(str -> votesMap.put((String)str, new HashSet()));
        List allVotes = this.pollVoteData.findByPoll(pdr.key());
        List<PollVoteDbRecord> votes = allVotes.stream().collect(Collectors.toMap(PollVoteDbRecord::voterKey, v -> v, (existing, replacing) -> existing.voteCount() > replacing.voteCount() ? existing : replacing)).values().stream().toList();
        for (PollVoteDbRecord pollVote : votes) {
            UserRecord user = this.userService.getUserByUserKey(pollVote.voterKey());
            pollVote.selectedOptions().forEach(idx -> ((Set)votesMap.get(pdr.options().get((int)idx))).add(user));
        }
        PollRecord answer = new PollRecord(pdr.question(), type, votesMap);
        return answer;
    }

    private MessageKey createMessageKeyForPoll(UserRecord sender, RecipientRecord receiver, long timestamp) {
        InsertMessageRequest messageRequest = new InsertMessageRequest();
        messageRequest.setReceiverKey(receiver.key());
        messageRequest.setSenderKey(sender.key());
        messageRequest.setTimestamp(timestamp);
        return this.messageService.insertMessage(messageRequest);
    }

    private MessageRecord createAndStoreMessageForPoll(UserRecord sender, RecipientRecord receiver, PollDbRecord pollDbRecord) {
        MessageRecord.Builder messageBuilder = new MessageRecord.Builder().receiverKey(receiver.key()).sender(sender).receiptType(ReceiptType.UNKNOWN);
        messageBuilder.pollRecord(this.createPollRecordFromDb(pollDbRecord));
        MessageRecord messageRecord = messageBuilder.build();
        InsertMessageRequest messageRequest = new InsertMessageRequest();
        messageRequest.setReceiverKey(receiver.key());
        messageRequest.setSenderKey(sender.key());
        return messageRecord;
    }
}

