/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.group.GroupData;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.message.InfoMessage;
import io.privacyresearch.clientdata.message.InsertMessageRequest;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.model.MessageRecord;
import io.privacyresearch.equation.signal.util.UuidUtil;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.user.UserService;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.protos.groups.local.DecryptedMember;
import org.signal.storageservice.protos.groups.local.DecryptedModifyMemberRole;

public class GroupChangeUtil {
    private static final Logger LOG = Logger.getLogger(GroupChangeUtil.class.getName());
    private final SqliteStorageBean sqliteStorageBean;
    private final GroupData groupData;
    private final MessagingClient messageListener;
    private final UserService userService;
    private final EquationManager wave;

    public GroupChangeUtil(EquationManager wave, UserService userService, SqliteStorageBean sqliteStorageBean, MessagingClient messageListener) {
        this.sqliteStorageBean = sqliteStorageBean;
        this.groupData = sqliteStorageBean.getGroupData();
        this.messageListener = messageListener;
        this.userService = userService;
        this.wave = wave;
    }

    private MessageRecord storeInfoMessage(InfoMessage infoMessage, UserRecord sender, RecipientRecord groupRecipient, long timestamp) {
        InsertMessageRequest insert = new InsertMessageRequest();
        insert.setInfoMessage(infoMessage);
        insert.setSenderKey(sender.key());
        insert.setContent("");
        insert.setReceiverKey(groupRecipient.key());
        insert.setReceivedTimestamp(System.currentTimeMillis());
        insert.setTimestamp(timestamp);
        MessageKey insertedKey = this.sqliteStorageBean.getMessageData().insertMessage(insert);
        MessageDbRecord messageDbRecord = (MessageDbRecord)this.sqliteStorageBean.getMessageData().findByKey((EntityKey)insertedKey);
        MessageRecord messageRecord = this.wave.getMessageRecordFromDb(messageDbRecord);
        this.messageListener.gotMessageRecord(messageRecord);
        LOG.info("infoMessage sent");
        return messageRecord;
    }

    GroupRecord process(DecryptedGroupChange change, UserRecord sender, RecipientRecord groupRecipient, long timestamp) {
        InfoMessage infoMessage;
        LOG.finer("Process change " + String.valueOf(change));
        GroupRecord group = this.groupData.getGroupByRecipientKey(groupRecipient.key());
        if (change.hasNewTimer()) {
            LOG.info("new timer!");
            int duration = change.getNewTimer().getDuration();
            this.groupData.modifyExpirationTime(group.key(), duration);
            group = this.groupData.getGroupByRecipientKey(groupRecipient.key());
            this.messageListener.updateGroupRecord(group);
            infoMessage = this.wave.createTimerInfoMessage(duration, sender.aci());
            this.storeInfoMessage(infoMessage, sender, groupRecipient, timestamp);
            LOG.info("infoMessage sent");
        }
        if (change.hasNewDescription()) {
            LOG.info("new description!");
            String desc = change.getNewDescription().getValue();
            this.groupData.updateDescription(group.key(), desc);
            infoMessage = this.wave.getAccount().getUser().aci().equals((Object)sender.aci()) ? new InfoMessage(InfoMessage.Type.INFO_GROUP_DESCRIPTION_ME, new String[]{desc}) : new InfoMessage(InfoMessage.Type.INFO_GROUP_DESCRIPTION_OTHER, new String[]{sender.aci().toServiceIdString(), desc});
            this.storeInfoMessage(infoMessage, sender, groupRecipient, timestamp);
            this.messageListener.gotInfoMessage(groupRecipient, timestamp, infoMessage);
        }
        if (change.hasNewTitle()) {
            LOG.info("new title!");
            String title = change.getNewTitle().getValue();
            this.groupData.updateTitle(group.key(), title);
            infoMessage = this.wave.getAccount().getUser().aci().equals((Object)sender.aci()) ? new InfoMessage(InfoMessage.Type.INFO_GROUP_TITLE_ME, new String[]{title}) : new InfoMessage(InfoMessage.Type.INFO_GROUP_TITLE_OTHER, new String[]{sender.aci().toServiceIdString(), title});
            this.storeInfoMessage(infoMessage, sender, groupRecipient, timestamp);
            this.messageListener.gotInfoMessage(groupRecipient, timestamp, infoMessage);
        }
        List newMembers = change.getNewMembersList();
        for (Object member : newMembers) {
            LOG.info("new members!");
            String memberName = this.getMemberNameFromByteString(member.getAciBytes());
            InfoMessage infoMessage2 = new InfoMessage(InfoMessage.Type.INFO_MEMBER_NEW, new String[]{memberName});
            this.storeInfoMessage(infoMessage2, sender, groupRecipient, timestamp);
            this.messageListener.gotInfoMessage(groupRecipient, timestamp, infoMessage2);
        }
        List removedMembers = change.getDeleteMembersList();
        for (ByteString member : removedMembers) {
            LOG.info("removed members!");
            String memberName = this.getMemberNameFromByteString(member);
            InfoMessage infoMessage3 = new InfoMessage(InfoMessage.Type.INFO_MEMBER_REMOVE, new String[]{memberName});
            this.storeInfoMessage(infoMessage3, sender, groupRecipient, timestamp);
            this.messageListener.gotInfoMessage(groupRecipient, timestamp, infoMessage3);
        }
        List modroles = change.getModifyMemberRolesList();
        for (DecryptedModifyMemberRole role : modroles) {
            String memberName = this.getMemberNameFromByteString(role.getAciBytes());
            InfoMessage infoMessage4 = new InfoMessage(InfoMessage.Type.INFO_ROLE_ME, new String[]{memberName, Integer.toString(role.getRoleValue())});
            this.storeInfoMessage(infoMessage4, sender, groupRecipient, timestamp);
            this.messageListener.gotInfoMessage(groupRecipient, timestamp, infoMessage4);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            for (DecryptedMember dm : change.getModifiedProfileKeysList()) {
                LOG.finest("PK changed for member with aci bytes = " + String.valueOf(dm.getAciBytes().toByteArray()));
            }
        }
        return this.groupData.getGroupByRecipientKey(groupRecipient.key());
    }

    private String getMemberNameFromByteString(ByteString bs) {
        UUID uuid = UuidUtil.fromByteString(bs);
        ServiceId.Aci aci = new ServiceId.Aci(uuid);
        return this.userService.getUserByServiceId((ServiceId)aci).map(UserRecord::name).orElse("someone we don't know");
    }

    void announceNewGroup(RecipientRecord groupRecipient, long timestamp) {
        InfoMessage infoMessage = new InfoMessage(InfoMessage.Type.INFO_GROUP_NEW_ME, new String[0]);
        this.messageListener.gotInfoMessage(groupRecipient, timestamp, infoMessage);
    }
}

