/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.user;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.badge.BadgeData;
import io.privacyresearch.clientdata.badge.BadgeDbRecord;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.equation.cache.TimedCache;
import io.privacyresearch.equation.user.BadgeRecord;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.util.AvatarHelper;
import java.io.File;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.thoughtcrime.securesms.backup.v2.proto.Backup;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.AccountRecord;
import org.whispersystems.signalservice.internal.storage.ContactRecord;

public class UserService {
    private static final Logger LOG = Logger.getLogger(UserService.class.getName());
    private final BadgeData badgeData;
    private final RecipientData recipientData;
    private final UserData userData;
    private final AvatarHelper avatarHelper;
    private final TimedCache<UserKey, UserRecord> userRecordCacheByKey = new TimedCache(Duration.ofSeconds(60L));
    private final TimedCache<ServiceId, UserRecord> userRecordCacheByServiceId = new TimedCache(Duration.ofSeconds(60L));
    private final TimedCache<RecipientKey, UserRecord> userRecordCacheByRecipientKey = new TimedCache(Duration.ofSeconds(60L));

    public UserService(BadgeData badgeData, RecipientData recipientData, UserData userData, AvatarHelper avatarHelper) {
        this.badgeData = badgeData;
        this.recipientData = recipientData;
        this.userData = userData;
        this.avatarHelper = avatarHelper;
    }

    public UserRecord storeAccountFromAci(ServiceId.Aci aci) {
        UserKey storedUserKey = this.userData.store((ServiceId)aci, null, true);
        UserDbRecord storedUserRecord = (UserDbRecord)this.userData.findByKey((EntityKey)storedUserKey);
        UserRecord userRecord = this.getUserRecordFromDbRecord(storedUserRecord);
        this.updateCaches(userRecord);
        return userRecord;
    }

    public UserRecord storeContactFromAci(ServiceId.Aci aci) {
        UserKey storedUserKey = this.userData.store((ServiceId)aci, null, false);
        UserDbRecord storedUserRecord = (UserDbRecord)this.userData.findByKey((EntityKey)storedUserKey);
        UserRecord userRecord = this.getUserRecordFromDbRecord(storedUserRecord);
        this.updateCaches(userRecord);
        return userRecord;
    }

    public UserRecord storeContactFromBackup(Backup.Contact contact) {
        UserKey storedUserKey = this.userData.storeContactFromBackup(contact);
        UserDbRecord storedUserRecord = (UserDbRecord)this.userData.findByKey((EntityKey)storedUserKey);
        UserRecord userRecord = this.getUserRecordFromDbRecord(storedUserRecord);
        this.updateCaches(userRecord);
        return userRecord;
    }

    public UserRecord createAccount(ServiceId.Aci aci, ServiceId.Pni pni, String retNumber, StorageId storageId, AccountRecord accountRecord) {
        UserKey userKey = this.userData.storePniVerified(aci, pni, retNumber);
        return this.storeAccountRecord(storageId, userKey, accountRecord);
    }

    public UserRecord storeAccountRecord(StorageId storageId, UserKey userKey, AccountRecord account) {
        this.userData.storeAccountRecord(storageId, userKey, account);
        UserDbRecord storedUserRecord = (UserDbRecord)this.userData.findByKey((EntityKey)userKey);
        UserRecord userRecord = this.getUserRecordFromDbRecord(storedUserRecord);
        this.updateCaches(userRecord);
        return userRecord;
    }

    public UserRecord storeContactRecord(StorageId storageId, ContactRecord contact) {
        UserKey storedUserKey = this.userData.storeContactRecord(storageId, contact);
        UserDbRecord storedUserRecord = (UserDbRecord)this.userData.findByKey((EntityKey)storedUserKey);
        UserRecord userRecord = this.getUserRecordFromDbRecord(storedUserRecord);
        this.updateCaches(userRecord);
        return userRecord;
    }

    public void storeProfile(ServiceId.Aci aci, SignalServiceProfile profile, byte[] profileKeyBytes) {
        this.userData.storeProfile((ServiceId)aci, profile, profileKeyBytes);
    }

    public void storePniVerified(ServiceId.Aci aci, ServiceId.Pni pni, String e164, byte[] profileKeyBytes) {
        UserKey storedUserKey = this.userData.storePniVerified(aci, pni, e164);
        try {
            this.userData.setProfileKey(storedUserKey, new ProfileKey(profileKeyBytes));
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        UserDbRecord storedUserRecord = (UserDbRecord)this.userData.findByKey((EntityKey)storedUserKey);
        UserRecord userRecord = this.getUserRecordFromDbRecord(storedUserRecord);
        this.updateCaches(userRecord);
    }

    public List<UserRecord> getAllUsers() {
        try {
            return this.userData.findAll().stream().map(this::getUserRecordFromDbRecord).toList();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public Optional<UserRecord> getUserByServiceId(ServiceId serviceId) {
        if (serviceId == null) {
            return Optional.empty();
        }
        UserRecord cachedUserRecord = this.userRecordCacheByServiceId.get(serviceId);
        if (cachedUserRecord != null) {
            return Optional.of(cachedUserRecord);
        }
        UserKey userKey = this.userData.getByServiceId(serviceId);
        if (userKey == null) {
            return Optional.empty();
        }
        UserRecord userRecord = this.getUserByUserKey(userKey);
        this.userRecordCacheByServiceId.put(serviceId, userRecord);
        return Optional.of(userRecord);
    }

    public UserRecord getOrCreateUserByServiceId(ServiceId serviceId) {
        if (serviceId == null) {
            throw new IllegalArgumentException("Provided serviceId argument can't be null.");
        }
        UserRecord cachedUserRecord = this.userRecordCacheByServiceId.get(serviceId);
        if (cachedUserRecord != null) {
            return cachedUserRecord;
        }
        UserKey userKey = this.userData.getByServiceId(serviceId);
        if (userKey == null) {
            userKey = this.userData.store(serviceId, null);
        }
        UserRecord userRecord = this.getUserByUserKey(userKey);
        this.userRecordCacheByServiceId.put(serviceId, userRecord);
        return userRecord;
    }

    public UserRecord getUserByRecipientKey(RecipientKey recipientKey) {
        UserRecord cachedUserRecord = this.userRecordCacheByRecipientKey.get(recipientKey);
        if (cachedUserRecord != null) {
            return cachedUserRecord;
        }
        UserDbRecord userDbRecord = this.userData.findByRecipientKey(recipientKey);
        if (userDbRecord == null) {
            return null;
        }
        UserRecord userRecord = this.getUserRecordFromDbRecord(userDbRecord);
        this.userRecordCacheByRecipientKey.put(recipientKey, userRecord);
        return userRecord;
    }

    public UserRecord getUserByUserKey(UserKey userKey) {
        UserRecord cachedUserRecord = this.userRecordCacheByKey.get(userKey);
        if (cachedUserRecord != null) {
            return cachedUserRecord;
        }
        UserRecord userRecord = this.getUserRecordFromDbRecord((UserDbRecord)this.userData.findByKey((EntityKey)userKey));
        this.userRecordCacheByKey.put(userKey, userRecord);
        return userRecord;
    }

    public static boolean isSameUserRecord(UserRecord a, UserRecord b) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (!UserService.bothNullOrEquals(a.key(), b.key())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.recipient(), b.recipient())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.aci(), b.aci())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.pni(), b.pni())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.e164(), b.e164())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.profileKey(), b.profileKey())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.profileGivenName(), b.profileGivenName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.profileFamilyName(), b.profileFamilyName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.username(), b.username())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.systemGivenName(), b.systemGivenName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.systemFamilyName(), b.systemFamilyName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.avatarPath(), b.avatarPath())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.about(), b.about())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.aboutEmoji(), b.aboutEmoji())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.nickGivenName(), b.nickGivenName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.nickFamilyName(), b.nickFamilyName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.nickNote(), b.nickNote())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.profileAvatarUrl(), b.profileAvatarUrl())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.sealedSenderMode(), b.sealedSenderMode())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.phoneNumberSharing(), b.phoneNumberSharing())) {
            return false;
        }
        return UserService.bothNullOrEquals(a.badges(), b.badges());
    }

    private static boolean bothNullOrEquals(Object a, Object b) {
        if (a == null != (b == null)) {
            return false;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a instanceof byte[]) {
            byte[] ba = (byte[])a;
            if (b instanceof byte[]) {
                byte[] bb = (byte[])b;
                return Arrays.equals(ba, bb);
            }
            return false;
        }
        return a.equals(b);
    }

    private void updateCaches(UserRecord userRecord) {
        this.userRecordCacheByKey.put(userRecord.key(), userRecord);
        userRecord.getServiceId().ifPresent(serviceId -> this.userRecordCacheByServiceId.put((ServiceId)serviceId, userRecord));
        this.userRecordCacheByRecipientKey.put(userRecord.recipient().key(), userRecord);
    }

    private UserRecord getUserRecordFromDbRecord(UserDbRecord db) {
        String name = this.getNameForUser(db);
        Optional<String> avatarPath = this.getAvatarPathForUser(db);
        RecipientRecord recipient = (RecipientRecord)this.recipientData.findByKey((EntityKey)db.recipientKey());
        List<BadgeRecord> badges = this.badgeData.getByUserKey(db.key()).stream().map(this::getBadgeRecordFromDb).toList();
        return new UserRecord(db.key(), recipient, db.aci(), db.pni(), db.e164(), db.profileKey(), name, db.profileGivenName(), db.profileFamilyName(), db.username(), db.systemGivenName(), db.systemFamilyName(), avatarPath, db.about(), db.aboutEmoji(), db.nickGivenName(), db.nickFamilyName(), db.nickNote(), db.profileAvatarUrl(), db.sealedSenderMode(), db.phoneNumberSharing(), badges);
    }

    private String getNameForUser(UserDbRecord db) {
        String name = Objects.toString(db.systemGivenName(), "") + " " + Objects.toString(db.systemFamilyName(), "");
        if (name.trim().isEmpty()) {
            name = Objects.toString(db.profileGivenName(), "") + " " + Objects.toString(db.profileFamilyName(), "");
        }
        return name.trim();
    }

    private Optional<String> getAvatarPathForUser(UserDbRecord user) {
        File avatarFile = this.avatarHelper.getAvatarFile(user.recipientKey());
        if (avatarFile.exists()) {
            return Optional.of(avatarFile.toString());
        }
        return Optional.empty();
    }

    private BadgeRecord getBadgeRecordFromDb(BadgeDbRecord db) {
        return new BadgeRecord(db.badgeId(), db.category(), db.name(), db.description(), db.duration(), db.expiration(), db.visible());
    }
}

