/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.proxy;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class WaveProxy {
    public static final String PREFERENCE_PROXYSERVER_ENABLED = "proxyserver.enabled";
    public static final String PREFERENCE_USE_PROXY = "proxy.use";
    static final int PORT = 9786;
    static final String TARGET_HOST = "chat.signal.org";
    private static final Logger LOG = Logger.getLogger(WaveProxy.class.getName());
    static List<String> restrictedHeader = List.of("Connection", "Host", "Upgrade", "Content-length");

    public WaveProxy() {
        LOG.info("Created WaveProxy");
    }

    public void startProxyService() {
        Thread t = new Thread(this){

            @Override
            public void run() {
                try {
                    LOG.info("Starting HTTP receiver");
                    InetSocketAddress isa = new InetSocketAddress(9786);
                    HttpServer server = HttpServer.create(isa, 10);
                    server.setExecutor(Executors.newFixedThreadPool(10));
                    server.createContext("/", new WaveProxyHandler());
                    server.start();
                    LOG.info("Started HTTP receiver");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        t.start();
    }

    static class WaveProxyHandler
    implements HttpHandler {
        HttpClient client = HttpClient.newHttpClient();

        WaveProxyHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                LOG.info("Proxy got a request");
                URI requestURI = exchange.getRequestURI();
                String path = requestURI.getPath();
                String query = requestURI.getQuery();
                String destination = "https://chat.signal.org" + path + (query == null ? "" : query);
                String method = exchange.getRequestMethod();
                HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(destination));
                builder.method(method, this.createRequestBody(exchange));
                LOG.info("Headers = " + String.valueOf(exchange.getRequestHeaders()));
                exchange.getRequestHeaders().forEach((key, values) -> LOG.info("Header " + key + " and val " + String.valueOf(values)));
                exchange.getRequestHeaders().forEach((key, values) -> {
                    if (!restrictedHeader.contains(key)) {
                        values.forEach(value -> builder.header((String)key, (String)value));
                    }
                });
                LOG.info("Proxy will forward request");
                HttpResponse<InputStream> response = this.client.send(builder.build(), HttpResponse.BodyHandlers.ofInputStream());
                LOG.info("Proxy got a response " + String.valueOf(response) + " with headers " + String.valueOf(response.headers()));
                LOG.info("body type = " + String.valueOf(response.body().getClass()));
                InputStream is = response.body();
                String jsonResponse = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
                exchange.sendResponseHeaders(response.statusCode(), jsonResponse.length());
                LOG.info("json response = " + jsonResponse + " with len = " + jsonResponse.length() + " or in bytes " + jsonResponse.getBytes().length);
                OutputStream responseBody = exchange.getResponseBody();
                responseBody.write(jsonResponse.getBytes(StandardCharsets.UTF_8));
                responseBody.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private HttpRequest.BodyPublisher createRequestBody(HttpExchange exchange) throws IOException {
            if (exchange.getRequestBody().available() > 0) {
                return HttpRequest.BodyPublishers.ofInputStream(exchange::getRequestBody);
            }
            return HttpRequest.BodyPublishers.noBody();
        }
    }
}

