/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PaddingInputStream
extends FilterInputStream {
    private long paddingRemaining;

    public PaddingInputStream(InputStream inputStream, long plaintextLength) {
        super(inputStream);
        this.paddingRemaining = PaddingInputStream.getPaddedSize(plaintextLength) - plaintextLength;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result != -1) {
            return result;
        }
        if (this.paddingRemaining > 0L) {
            --this.paddingRemaining;
            return 0;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int result = super.read(buffer, offset, length);
        if (result != -1) {
            return result;
        }
        if (this.paddingRemaining > 0L) {
            length = Math.min(length, PaddingInputStream.toIntExact(this.paddingRemaining));
            this.paddingRemaining -= (long)length;
            return length;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int available() throws IOException {
        return super.available() + PaddingInputStream.toIntExact(this.paddingRemaining);
    }

    public static long getPaddedSize(long size) {
        return (int)Math.max(541.0, Math.floor(Math.pow(1.05, Math.ceil(Math.log(size) / Math.log(1.05)))));
    }

    public static int toIntExact(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }
}

