/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.net;

import com.gluonhq.snl.doubt.MediaType;
import com.gluonhq.snl.doubt.RequestBody;
import io.privacyresearch.equation.attachment.SignalServiceAttachment;
import io.privacyresearch.equation.net.AttachmentCipherOutputStreamFactory;
import io.privacyresearch.equation.net.CancelationSignal;
import io.privacyresearch.equation.net.OutputStreamFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.incrementalmac.ChunkSizeChoice;
import org.whispersystems.signalservice.api.crypto.AttachmentDigest;
import org.whispersystems.signalservice.api.crypto.DigestingOutputStream;
import org.whispersystems.signalservice.api.crypto.SkippingOutputStream;

public class DigestingRequestBody
extends RequestBody {
    private final InputStream inputStream;
    private final OutputStreamFactory outputStreamFactory;
    private final String contentType;
    private final long contentLength;
    private final boolean incremental;
    private final SignalServiceAttachment.ProgressListener progressListener;
    private final CancelationSignal cancelationSignal;
    private final long contentStart;
    private AttachmentDigest attachmentDigest;

    public DigestingRequestBody(InputStream inputStream, OutputStreamFactory outputStreamFactory, String contentType, long contentLength, boolean incremental, SignalServiceAttachment.ProgressListener progressListener, CancelationSignal cancelationSignal, long contentStart) {
        assert (contentLength >= contentStart);
        assert (contentStart >= 0L);
        this.inputStream = inputStream;
        this.outputStreamFactory = outputStreamFactory;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.incremental = incremental;
        this.progressListener = progressListener;
        this.cancelationSignal = cancelationSignal;
        this.contentStart = contentStart;
    }

    @Override
    public MediaType contentType() {
        return MediaType.parse(this.contentType);
    }

    @Override
    public void writeTo(OutputStream sink) throws IOException {
        int read;
        ByteArrayOutputStream digestStream = new ByteArrayOutputStream();
        SkippingOutputStream inner = new SkippingOutputStream(this.contentStart, sink);
        boolean isIncremental = this.incremental && this.outputStreamFactory instanceof AttachmentCipherOutputStreamFactory;
        ChunkSizeChoice sizeChoice = ChunkSizeChoice.inferChunkSize((int)((int)this.contentLength));
        DigestingOutputStream outputStream = isIncremental ? ((AttachmentCipherOutputStreamFactory)this.outputStreamFactory).createIncrementalFor((OutputStream)inner, this.contentLength, sizeChoice, digestStream) : this.outputStreamFactory.createFor((OutputStream)inner);
        byte[] buffer = new byte[8192];
        long total = 0L;
        while ((read = this.inputStream.read(buffer, 0, buffer.length)) != -1) {
            if (this.cancelationSignal != null && this.cancelationSignal.isCanceled()) {
                throw new IOException("Canceled!");
            }
            outputStream.write(buffer, 0, read);
            total += (long)read;
            if (this.progressListener == null) continue;
            this.progressListener.onAttachmentProgress(this.contentLength, total);
        }
        outputStream.flush();
        Object incrementalDigest = null;
        if (isIncremental) {
            outputStream.close();
            digestStream.close();
            digestStream.toByteArray();
        }
        this.attachmentDigest = new AttachmentDigest(outputStream.getTransmittedDigest(), Optional.ofNullable(incrementalDigest), sizeChoice.getSizeInBytes());
    }

    @Override
    public long contentLength() {
        if (this.contentLength > 0L) {
            return this.contentLength - this.contentStart;
        }
        return -1L;
    }

    public AttachmentDigest getAttachmentDigest() {
        return this.attachmentDigest;
    }

    @Override
    public byte[] getRawBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.writeTo(baos);
            baos.flush();
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            Logger.getLogger(DigestingRequestBody.class.getName()).log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }
}

