/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Base64;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.kem.KEMPublicKey;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;

public class KyberPreKeyEntity {
    @JsonProperty
    private int keyId;
    @JsonProperty
    @JsonSerialize(using=KEMPublicKeySerializer.class)
    @JsonDeserialize(using=KEMPublicKeyDeserializer.class)
    private KEMPublicKey publicKey;
    @JsonProperty
    @JsonSerialize(using=ByteArraySerializer.class)
    @JsonDeserialize(using=ByteArrayDeserializer.class)
    private byte[] signature;

    public KyberPreKeyEntity() {
    }

    public KyberPreKeyEntity(int keyId, KEMPublicKey publicKey, byte[] signature) {
        this.keyId = keyId;
        this.publicKey = publicKey;
        this.signature = signature;
    }

    public KyberPreKeyEntity(KyberPreKeyRecord record) throws InvalidKeyException {
        this.keyId = record.getId();
        this.publicKey = record.getKeyPair().getPublicKey();
        this.signature = record.getSignature();
    }

    public int getKeyId() {
        return this.keyId;
    }

    public KEMPublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    private static class ByteArrayDeserializer
    extends JsonDeserializer<byte[]> {
        private ByteArrayDeserializer() {
        }

        public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Base64.getDecoder().decode(p.getValueAsString());
        }
    }

    private static class ByteArraySerializer
    extends JsonSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Base64.getEncoder().withoutPadding().encodeToString(value));
        }
    }

    private static class KEMPublicKeyDeserializer
    extends JsonDeserializer<KEMPublicKey> {
        private KEMPublicKeyDeserializer() {
        }

        public KEMPublicKey deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return new KEMPublicKey(Base64.getDecoder().decode(p.getValueAsString()), 0);
            }
            catch (InvalidKeyException e) {
                throw new IOException(e);
            }
        }
    }

    private static class KEMPublicKeySerializer
    extends JsonSerializer<KEMPublicKey> {
        private KEMPublicKeySerializer() {
        }

        public void serialize(KEMPublicKey value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Base64.getEncoder().encodeToString(value.serialize()));
        }
    }
}

