/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model;

import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.InfoMessage;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.ReceiptType;
import io.privacyresearch.clientdata.message.StoryType;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.equation.model.ContactRecord;
import io.privacyresearch.equation.user.UserRecord;
import java.util.List;

public record MessageRecord(MessageKey key, ChannelKey channelKey, UserRecord sender, RecipientKey receiverKey, String body, List<BodyRange> bodyRanges, long dateSent, long dateReceived, ReceiptType receiptType, long receiptTimestamp, int expiresIn, long expireStarted, StoryType storyType, InfoMessage infoMessage, ContactRecord contactRecord, boolean read, boolean viewOnce, long flags, MessageKey originalMessageKey, List<MessageKey> parentKeys, MessageKey threadRootKey) {
    public boolean isDeleted() {
        long mask = 1L;
        return (this.flags() & mask) != 0L;
    }

    public boolean hasPqRatchet() {
        long mask = 2L;
        return (this.flags() & mask) != 0L;
    }

    public static class Builder {
        MessageKey key = new MessageKey();
        ChannelKey channelKey;
        UserRecord sender;
        RecipientKey receiverKey;
        String body;
        List<BodyRange> bodyRanges;
        long dateSent;
        long dateReceived;
        ReceiptType receiptType;
        long receiptTimestamp;
        int expiresIn;
        long expireStarted;
        StoryType storyType;
        InfoMessage infoMessage;
        ContactRecord contactRecord;
        boolean read;
        long flags;
        MessageKey originalMessageKey;
        boolean viewOnce;
        List<MessageKey> parentKeys;
        MessageKey threadRootKey;

        public Builder messageKey(MessageKey key) {
            this.key = key;
            return this;
        }

        public Builder channelKey(ChannelKey val) {
            this.channelKey = val;
            return this;
        }

        public Builder sender(UserRecord val) {
            this.sender = val;
            return this;
        }

        public Builder receiverKey(RecipientKey val) {
            this.receiverKey = val;
            return this;
        }

        public Builder body(String val) {
            this.body = val;
            return this;
        }

        public Builder bodyRanges(List<BodyRange> val) {
            this.bodyRanges = val;
            return this;
        }

        public Builder contactRecord(ContactRecord val) {
            this.contactRecord = val;
            return this;
        }

        public Builder dateSent(long v) {
            this.dateSent = v;
            return this;
        }

        public Builder dateReceived(long v) {
            this.dateReceived = v;
            return this;
        }

        public Builder receiptType(ReceiptType val) {
            this.receiptType = val;
            return this;
        }

        public Builder receiptTimestamp(long val) {
            this.receiptTimestamp = val;
            return this;
        }

        public Builder expiresIn(int val) {
            this.expiresIn = val;
            return this;
        }

        public Builder expireStarted(long val) {
            this.expireStarted = val;
            return this;
        }

        public Builder storyType(StoryType val) {
            this.storyType = val;
            return this;
        }

        public Builder infoMessage(InfoMessage val) {
            this.infoMessage = val;
            return this;
        }

        public Builder read(boolean val) {
            this.read = val;
            return this;
        }

        public Builder flags(long val) {
            this.flags = val;
            return this;
        }

        public Builder originalMessageKey(MessageKey val) {
            this.originalMessageKey = val;
            return this;
        }

        public Builder viewOnce(boolean val) {
            this.viewOnce = val;
            return this;
        }

        public Builder parentKeys(List<MessageKey> val) {
            this.parentKeys = val;
            return this;
        }

        public Builder threadRootKey(MessageKey val) {
            this.threadRootKey = val;
            return this;
        }

        public MessageRecord build() {
            if (this.key == null) {
                throw new IllegalStateException("MessageKey has been set to null.");
            }
            return new MessageRecord(this.key, this.channelKey, this.sender, this.receiverKey, this.body, this.bodyRanges, this.dateSent, this.dateReceived, this.receiptType, this.receiptTimestamp, this.expiresIn, this.expireStarted, this.storyType, this.infoMessage, this.contactRecord, this.read, this.viewOnce, this.flags, this.originalMessageKey, this.parentKeys, this.threadRootKey);
        }
    }
}

