/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model;

import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.InfoMessage;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentPointer;
import io.privacyresearch.equation.model.Attachment;
import io.privacyresearch.equation.model.AttachmentPointer;
import io.privacyresearch.equation.model.ContactRecord;
import io.privacyresearch.equation.model.MessageRecord;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;

public class Message {
    UserKey senderKey;
    RecipientKey receiverKey;
    MessageKey key;
    String content;
    long timestamp;
    long serverTimestamp;
    long expireTimestamp;
    long origTimestamp;
    long receivedTimestamp;
    int expiration;
    String receiverUuid;
    int expireTimerUpdate = -1;
    boolean viewOnce = false;
    byte[] mkb;
    int groupRevision;
    byte[] profileKeyBytes;
    String channelUuid;
    List<Attachment> attachment = new LinkedList<Attachment>();
    List<AttachmentPointer> attachmentPointers = new LinkedList<AttachmentPointer>();
    List<BodyRange> bodyRanges = new LinkedList<BodyRange>();
    private WaveReaction reaction;
    private ContactRecord contact;
    private InfoMessage infoMessage;
    private MessageKey quotedMessageKey;
    private MessageKey threadRootKey;

    public Message() {
    }

    public Message(MessageRecord record) {
        this.content = record.body();
        this.senderKey = record.sender().key();
        this.receiverKey = record.receiverKey();
        this.timestamp = record.dateSent();
        this.receivedTimestamp = record.dateReceived();
        this.key = record.key();
        this.contact = record.contactRecord();
    }

    public MessageKey getKey() {
        return this.key;
    }

    public void setMasterKeyBytes(byte[] b) {
        this.mkb = b;
    }

    public byte[] getMasterKeyBytes() {
        return this.mkb;
    }

    public void setGroupRevision(int r) {
        this.groupRevision = r;
    }

    public int getGroupRevision() {
        return this.groupRevision;
    }

    public void setProfileKeyBytes(byte[] b) {
        this.profileKeyBytes = b;
    }

    public byte[] getProfileKeyBytes() {
        return this.profileKeyBytes;
    }

    public Message senderKey(UserKey senderKey) {
        this.senderKey = senderKey;
        return this;
    }

    public Message receiverKey(RecipientKey receiverKey) {
        this.receiverKey = receiverKey;
        return this;
    }

    public Message content(String content) {
        this.content = content;
        return this;
    }

    public Message receiverUuid(String v) {
        this.receiverUuid = v;
        return this;
    }

    public Message timestamp(long v) {
        this.timestamp = v;
        return this;
    }

    public Message receivedTimestamp(long v) {
        this.receivedTimestamp = v;
        return this;
    }

    public Message origTimestamp(long v) {
        this.origTimestamp = v;
        return this;
    }

    public Message serverTimestamp(long v) {
        this.serverTimestamp = v;
        return this;
    }

    public Message attachment(Attachment att) {
        this.attachment.add(att);
        return this;
    }

    public Message attachment(Path p, String name) {
        Attachment att = new Attachment(p, name);
        this.attachment.add(att);
        return this;
    }

    public Message attachmentPointer(SignalServiceAttachmentPointer pointer, String location) {
        this.attachmentPointers.add(new AttachmentPointer(pointer, location));
        return this;
    }

    public Message channelUuid(String c) {
        this.channelUuid = c;
        return this;
    }

    public Message bodyRanges(List<BodyRange> bodyRanges) {
        this.bodyRanges = bodyRanges;
        return this;
    }

    public Message reaction(WaveReaction r) {
        this.reaction = r;
        return this;
    }

    public Message quotedMessageKey(MessageKey quotedMessageKey) {
        this.quotedMessageKey = quotedMessageKey;
        return this;
    }

    public Message threadRootKey(MessageKey threadRootKey) {
        this.threadRootKey = threadRootKey;
        return this;
    }

    public Message expireTimerUpdate(int v) {
        this.expireTimerUpdate = v;
        return this;
    }

    public Message viewOnce(boolean v) {
        this.viewOnce = v;
        return this;
    }

    public Message infoMessage(InfoMessage im) {
        this.infoMessage = im;
        return this;
    }

    public UserKey getSenderKey() {
        return this.senderKey;
    }

    public RecipientKey getReceiverKey() {
        return this.receiverKey;
    }

    public String getContent() {
        return this.content;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getReceivedTimestamp() {
        return this.receivedTimestamp;
    }

    public long getOrigTimestamp() {
        return this.origTimestamp;
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }

    public String getReceiverUuid() {
        return this.receiverUuid;
    }

    public List<AttachmentPointer> getAttachmentPointers() {
        return this.attachmentPointers;
    }

    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    public List<BodyRange> getBodyRanges() {
        return this.bodyRanges;
    }

    public MessageKey getQuotedMessageKey() {
        return this.quotedMessageKey;
    }

    public MessageKey getThreadRootKey() {
        return this.threadRootKey;
    }

    public WaveReaction getReaction() {
        return this.reaction;
    }

    public InfoMessage getInfoMessage() {
        return this.infoMessage;
    }

    public void setExpireTimestamp(long v) {
        this.expireTimestamp = v;
    }

    public long getExpireTimestamp() {
        return this.expireTimestamp;
    }

    public void setExpiration(int s) {
        this.expiration = s;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public int getExpireTimerUpdate() {
        return this.expireTimerUpdate;
    }

    public boolean isViewOnce() {
        return this.viewOnce;
    }

    public String getChannelUuid() {
        return this.channelUuid;
    }

    public static class WaveReaction {
        final String emoji;
        final boolean remove;
        final String targetAuthorUuid;
        final long targetTimestamp;

        public WaveReaction(String emoji, boolean remove, String tau, long tst) {
            this.emoji = emoji;
            this.remove = remove;
            this.targetAuthorUuid = tau;
            this.targetTimestamp = tst;
        }

        public long getTargetTimestamp() {
            return this.targetTimestamp;
        }

        public String getEmoji() {
            return this.emoji;
        }

        public boolean getRemove() {
            return this.remove;
        }
    }
}

