/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model;

import java.util.List;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public record ContactRecord(String firstName, String lastName, List<EmailRecord> email, List<PhoneRecord> phone) {
    public static ContactRecord create(SignalServiceProtos.DataMessage.Contact contact) {
        SignalServiceProtos.DataMessage.Contact.Name name = contact.getName();
        List<PhoneRecord> phoneNumbers = contact.getNumberCount() == 0 ? null : contact.getNumberList().stream().map(p -> new PhoneRecord(p.getLabel(), ContactRecord.phoneType(p.getType()), p.getValue())).toList();
        List<EmailRecord> emails = contact.getEmailCount() == 0 ? null : contact.getEmailList().stream().map(p -> new EmailRecord(p.getLabel(), ContactRecord.emailType(p.getType()), p.getValue())).toList();
        return new ContactRecord(name.getGivenName(), name.getFamilyName(), emails, phoneNumbers);
    }

    static PhoneType phoneType(SignalServiceProtos.DataMessage.Contact.Phone.Type t) {
        return switch (t) {
            default -> throw new MatchException(null, null);
            case SignalServiceProtos.DataMessage.Contact.Phone.Type.HOME -> PhoneType.HOME;
            case SignalServiceProtos.DataMessage.Contact.Phone.Type.MOBILE -> PhoneType.MOBILE;
            case SignalServiceProtos.DataMessage.Contact.Phone.Type.WORK -> PhoneType.WORK;
            case SignalServiceProtos.DataMessage.Contact.Phone.Type.CUSTOM -> PhoneType.CUSTOM;
        };
    }

    static EmailType emailType(SignalServiceProtos.DataMessage.Contact.Email.Type t) {
        return switch (t) {
            default -> throw new MatchException(null, null);
            case SignalServiceProtos.DataMessage.Contact.Email.Type.HOME -> EmailType.HOME;
            case SignalServiceProtos.DataMessage.Contact.Email.Type.MOBILE -> EmailType.MOBILE;
            case SignalServiceProtos.DataMessage.Contact.Email.Type.WORK -> EmailType.WORK;
            case SignalServiceProtos.DataMessage.Contact.Email.Type.CUSTOM -> EmailType.CUSTOM;
        };
    }

    public static enum PhoneType {
        HOME,
        MOBILE,
        WORK,
        CUSTOM;

    }

    public static enum EmailType {
        HOME,
        MOBILE,
        WORK,
        CUSTOM;

    }

    public record EmailRecord(String label, EmailType type, String value) {
    }

    public record PhoneRecord(String label, PhoneType type, String value) {
    }
}

