/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.mediaserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.attachment.AttachmentRecord;
import io.privacyresearch.equation.EquationManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherInputStream;

public class LocalMediaServer {
    private EquationManager waveManager;
    static final String CONTEXT = "/media";
    static final int PORT = 8123;
    static final int NUM_THREADS = 40;
    static final int BACKLOG = 10;
    boolean useQuic = false;
    private static final Logger LOG = Logger.getLogger(LocalMediaServer.class.getName());
    private HttpServer server;
    static int requestCounter = 0;

    public LocalMediaServer(EquationManager waveManager) {
        try {
            this.waveManager = waveManager;
            this.createServer();
        }
        catch (IOException ex) {
            Logger.getLogger(LocalMediaServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private HttpServer createServer() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(8123), 10);
        this.server.setExecutor(Executors.newFixedThreadPool(40));
        this.server.createContext(CONTEXT, new LocalMediaHandler());
        LOG.info("Created local httpserver at port 8123 with 40 processing threads:" + String.valueOf(this.server));
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    LOG.info("Starting local HttpServer in thread " + String.valueOf(Thread.currentThread()));
                    LocalMediaServer.this.server.start();
                    LOG.info("Started local HttpServer in thread " + String.valueOf(Thread.currentThread()));
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        t.setName("LocalHttpServer");
        t.start();
        return this.server;
    }

    public void shutdown() {
        if (this.server != null) {
            this.server.stop(0);
        }
    }

    private AttachmentRecord getAttachmentRecord(String path) {
        LOG.info("Decode path " + path);
        byte[] attKey = Base64.getUrlDecoder().decode(path);
        AttachmentKey key = new AttachmentKey(attKey);
        AttachmentRecord record = (AttachmentRecord)this.waveManager.getSqliteStorageBean().getAttachmentData().findByKey((EntityKey)key);
        LOG.finest("got attachment: " + String.valueOf(record));
        return record;
    }

    public InputStream getInputStreamForPath(String path) throws IOException {
        try {
            AttachmentRecord record = this.getAttachmentRecord(path);
            LOG.info("got attachment: " + String.valueOf(record));
            Path encryptedDownload = Path.of(record.location() + ".enc", new String[0]);
            if (Files.exists(encryptedDownload, new LinkOption[0])) {
                LOG.info("Got this locally");
                File encFile = encryptedDownload.toFile();
                return AttachmentCipherInputStream.createForAttachment((File)encFile, (long)record.size(), (byte[])record.remoteKey(), (byte[])record.digest());
            }
            encryptedDownload = Path.of(record.location(), new String[0]);
            if (Files.exists(encryptedDownload, new LinkOption[0])) {
                LOG.info("Got this locally (without enc)");
                File encFile = encryptedDownload.toFile();
                return AttachmentCipherInputStream.createForAttachment((File)encFile, (long)record.size(), (byte[])record.remoteKey(), (byte[])record.digest());
            }
            LOG.info("Don't have this yet locally");
            Thread.dumpStack();
            throw new RuntimeException();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException(t);
        }
    }

    class LocalMediaHandler
    implements HttpHandler {
        static AtomicInteger uniqueCnt = new AtomicInteger(0);

        LocalMediaHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) {
            try {
                int rlen;
                URI uri = exchange.getRequestURI();
                Headers requestHeaders = exchange.getRequestHeaders();
                String rangeString = requestHeaders.getFirst("Range");
                boolean range = false;
                int rangeStart = 0;
                int rangeEnd = 0;
                if (rangeString != null && rangeString.startsWith("bytes=")) {
                    range = true;
                    String totRange = rangeString.substring(6);
                    int sep = totRange.indexOf("-");
                    String first = totRange.substring(0, sep);
                    String second = totRange.substring(sep + 1);
                    rangeStart = Integer.parseInt(first);
                    rangeEnd = Integer.parseInt(second);
                }
                int myCounter = ++requestCounter;
                LOG.info("Need to process " + String.valueOf(uri) + " with requestmethod = " + exchange.getRequestMethod() + " and Thread = " + String.valueOf(Thread.currentThread()) + ", requestCounter = " + myCounter);
                LOG.info("requestheaders = " + String.valueOf(exchange.getRequestHeaders()) + " and body = " + String.valueOf(exchange.getRequestBody()));
                String path = uri.toString().substring(LocalMediaServer.CONTEXT.length() + 1);
                LOG.info("Path = " + path);
                AttachmentRecord record = LocalMediaServer.this.getAttachmentRecord(path);
                boolean isHead = exchange.getRequestMethod().equalsIgnoreCase("head");
                LOG.info("Handle media on Thread " + String.valueOf(Thread.currentThread()));
                exchange.getResponseHeaders().set("Content-Type", record.contentType());
                exchange.getResponseHeaders().set("Accept-Ranges", "bytes");
                String eTag = Base64.getEncoder().encodeToString(record.remoteKey());
                exchange.getResponseHeaders().set("ETag", eTag);
                exchange.getResponseHeaders().set("Connection", "keep-alive");
                if (range) {
                    rlen = rangeEnd - rangeStart + 1;
                    exchange.getResponseHeaders().set("Content-Range", "bytes " + rangeStart + "-" + rangeEnd + "/" + record.size());
                    exchange.getResponseHeaders().set("Content-Length", Integer.toString(rlen));
                } else {
                    exchange.getResponseHeaders().add("Content-Length", Integer.toString(record.size()));
                }
                LOG.fine("HEADERS = " + String.valueOf(exchange.getResponseHeaders()));
                if (range) {
                    rlen = rangeEnd - rangeStart + 1;
                    exchange.sendResponseHeaders(206, rlen);
                } else {
                    exchange.sendResponseHeaders(200, 0L);
                }
                if (isHead) {
                    LOG.info("We only needed the HEAD, so return now");
                    exchange.close();
                    return;
                }
                InputStream mediaInputStream = LocalMediaServer.this.getInputStreamForPath(path);
                LOG.info("start writing to responsebody on Thread " + String.valueOf(Thread.currentThread()));
                long totread = 0L;
                try (OutputStream outputStream = exchange.getResponseBody();){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    System.err.println("read...");
                    Path safePath = Files.createFile(Path.of("/tmp/dec" + System.currentTimeMillis() + "_" + uniqueCnt.getAndIncrement(), new String[0]), new FileAttribute[0]);
                    File safe = safePath.toFile();
                    FileOutputStream fos = new FileOutputStream(safe);
                    if (range && rangeStart > 0) {
                        int skipped;
                        byte[] skip = new byte[rangeStart];
                        for (int totalSkipped = skipped = mediaInputStream.read(skip); totalSkipped < rangeStart; totalSkipped += skipped) {
                            skipped = mediaInputStream.read(skip, totalSkipped, rangeStart - totalSkipped);
                        }
                    }
                    int rneeded = rangeEnd - rangeStart + 1;
                    while ((bytesRead = mediaInputStream.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytesRead);
                        fos.flush();
                        LOG.finest("read done for tot = " + (totread += (long)bytesRead) + ", br = " + bytesRead + " and rn = " + rneeded + ", now write");
                        if (range && bytesRead > rneeded) {
                            outputStream.write(buffer, 0, rneeded);
                        } else {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                        rneeded -= bytesRead;
                        outputStream.flush();
                        LOG.finest("write done");
                    }
                    LOG.info("all done");
                    fos.close();
                }
                catch (Exception e) {
                    LOG.info("Error in request with counter " + myCounter + " after " + totread);
                    e.printStackTrace();
                }
                LOG.info("done writing");
            }
            catch (IOException ex) {
                Logger.getLogger(LocalMediaServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

