/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.export;

public class ExportOptions {
    private boolean includeMedia = false;
    private ExportType exportType = ExportType.TEXT;

    public boolean isIncludeMedia() {
        return this.includeMedia;
    }

    public ExportOptions includeMedia(boolean v) {
        this.includeMedia = v;
        return this;
    }

    public ExportType getExportType() {
        return this.exportType;
    }

    public ExportOptions exportType(ExportType t) {
        this.exportType = t;
        return this;
    }

    public static enum ExportType {
        TEXT("Text", "*.txt"),
        JSON("Json", "*.json"),
        HTML("HTML", "*.html");

        private final String description;
        private final String extension;

        private ExportType(String description, String extension) {
            this.description = description;
            this.extension = extension;
        }

        public String getDescription() {
            return this.description;
        }

        public String getExtension() {
            return this.extension;
        }

        public static ExportType getByDescription(String desc) {
            for (ExportType type : ExportType.values()) {
                if (!type.getDescription().equals(desc)) continue;
                return type;
            }
            return null;
        }
    }
}

